/*
 * Decompiled with CFR 0.152.
 */
package in.erail.service;

import com.google.common.net.MediaType;
import in.erail.model.Event;
import in.erail.service.RESTServiceImpl;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Optional;

public class HelloService
extends RESTServiceImpl {
    private JsonArray mHelloData = new JsonArray();

    public HelloService() {
        this.mHelloData.add("S1");
        this.mHelloData.add("S2");
        this.mHelloData.add("S3");
        this.mHelloData.add("S4");
        this.mHelloData.add("S5");
    }

    public MaybeSource<Event> process(Maybe<Event> pEvent) {
        return pEvent.doOnSuccess(e -> {
            byte[] result;
            int contentLength = e.getRequest().bodyAsString().length();
            String header = Optional.ofNullable((String)e.getRequest().getHeaders().get("aws-event-source")).orElse("");
            if (contentLength == 0) {
                result = this.getHelloData().toString().getBytes();
            } else {
                JsonObject newResp = new JsonObject();
                newResp.put("length", Integer.valueOf(contentLength));
                newResp.put("aws-event-source", header);
                result = newResp.toString().getBytes();
            }
            e.getResponse().setBody(result).setMediaType(MediaType.JSON_UTF_8);
        });
    }

    public JsonArray getHelloData() {
        return this.mHelloData;
    }

    public void setHelloData(JsonArray pHelloData) {
        this.mHelloData = pHelloData;
    }
}

