/*
 * Decompiled with CFR 0.152.
 */
package in.erail.amazon.lambda.eventsource;

import com.google.common.net.MediaType;
import in.erail.amazon.lambda.EventSource;
import in.erail.glue.common.Util;
import io.vertx.core.json.JsonObject;
import java.util.Optional;

public class S3EventSource
implements EventSource {
    public static final String S3_URL = "/aws/s3";
    public static final String S3_ENV_NAME = "api.framework.lambda.s3.url";
    private final String s3url = Util.getEnvironmentValue((String)"api.framework.lambda.s3.url", (String)"/aws/s3");

    @Override
    public boolean check(JsonObject pEvent) {
        return pEvent.containsKey("Records") && Optional.ofNullable(pEvent.getJsonArray("Records")).filter(o -> o.size() >= 1).map(o -> (JsonObject)o.iterator().next()).filter(o -> o.containsKey("s3")).isPresent();
    }

    @Override
    public JsonObject transform(JsonObject pEvent) {
        JsonObject newRequest = new JsonObject().put("path", this.s3url).put("httpMethod", "POST").put("body", pEvent.toString().getBytes()).put("headers", new JsonObject().put("Content-Type", MediaType.JSON_UTF_8.toString()));
        return newRequest;
    }
}

