/*
 * Decompiled with CFR 0.152.
 */
package in.erail.amazon.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import in.erail.glue.Glue;
import in.erail.glue.common.Util;
import in.erail.model.Event;
import in.erail.model.RequestEvent;
import in.erail.service.RESTService;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AWSLambda
implements RequestStreamHandler {
    protected Logger log = LogManager.getLogger((String)AWSLambda.class.getCanonicalName());
    private static final String SERVICE_ENV = "service";
    private final RESTService mService;
    private final List<String> allowedFields = new ArrayList<String>();

    public AWSLambda() {
        this.allowedFields.add("isBase64Encoded");
        this.allowedFields.add("statusCode");
        this.allowedFields.add("headers");
        this.allowedFields.add("multiValueHeaders");
        this.allowedFields.add("body");
        String component = Util.getEnvironmentValue((String)SERVICE_ENV);
        if (Strings.isNullOrEmpty((String)component)) {
            throw new RuntimeException("Service not defined in lambda environment");
        }
        this.mService = (RESTService)Glue.instance().resolve(component);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
            JsonObject requestJson = new JsonObject(Buffer.buffer((byte[])ByteStreams.toByteArray((InputStream)inputStream)));
            this.log.debug(() -> requestJson.toString());
            String resp = (String)this.handleMessage(requestJson).blockingGet();
            this.log.debug(() -> resp);
            writer.write(resp);
        }
    }

    public Single<String> handleMessage(JsonObject pRequest) {
        return Single.just((Object)pRequest).subscribeOn(Schedulers.computation()).map(this::convertBodyToBase64).map(reqJson -> (RequestEvent)reqJson.mapTo(this.getService().getRequestEventClass())).doOnSuccess(this::populateSystemProperties).flatMapMaybe(req -> this.getService().handleEvent(this.getService().createEvent(req))).toSingle((Object)new Event()).map(resp -> JsonObject.mapFrom((Object)resp.getResponse())).map(this::sanatizeResponse).map(respJson -> respJson.toString());
    }

    protected void populateSystemProperties(RequestEvent pRequest) {
        Optional.ofNullable(pRequest.getRequestContext().get("stage")).ifPresent(s -> System.setProperty("stage", s.toString()));
    }

    protected JsonObject sanatizeResponse(JsonObject pResp) {
        Preconditions.checkNotNull((Object)pResp);
        HashSet keys = new HashSet(pResp.fieldNames());
        keys.stream().filter(key -> !this.allowedFields.contains(key)).forEach(key -> pResp.remove(key));
        return pResp;
    }

    protected JsonObject convertBodyToBase64(JsonObject pRequest) {
        Boolean isBase64Encoded = Optional.ofNullable(pRequest.getBoolean("isBase64Encoded")).orElse(Boolean.FALSE);
        if (!isBase64Encoded.booleanValue() && pRequest.containsKey("body")) {
            Optional<String> body = Optional.ofNullable(pRequest.getString("body"));
            body.ifPresent(t -> {
                pRequest.remove("body");
                pRequest.put("body", ((String)body.get()).getBytes());
            });
        }
        return pRequest;
    }

    public RESTService getService() {
        return this.mService;
    }
}

