/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook;

import com.google.gson.annotations.SerializedName;
import in.ashwanthkumar.slack.webhook.SlackMessage;
import java.util.ArrayList;
import java.util.List;

public class SlackAttachment {
    @SerializedName(value="fallback")
    private String fallback;
    @SerializedName(value="color")
    private String color;
    @SerializedName(value="pretext")
    private String pretext;
    @SerializedName(value="author_name")
    private String authorName;
    @SerializedName(value="author_link")
    private String authorLink;
    @SerializedName(value="author_icon")
    private String authorIcon;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="title_link")
    private String titleLink;
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="image_url")
    private String imageUrl;
    @SerializedName(value="fields")
    private List<Field> fields = new ArrayList<Field>();
    @SerializedName(value="mrkdwn_in")
    private List<String> markdown = new ArrayList<String>();

    public SlackAttachment(String text) {
        this.text(text);
    }

    public SlackAttachment fallback(String fallbackText) {
        this.fallback = fallbackText;
        return this;
    }

    public SlackAttachment color(String colorInHex) {
        this.color = colorInHex;
        return this;
    }

    public SlackAttachment preText(String pretext) {
        this.pretext = pretext;
        return this;
    }

    public SlackAttachment author(String name) {
        this.authorName = name;
        return this;
    }

    public SlackAttachment author(String name, String link) {
        this.authorLink = link;
        return this.author(name);
    }

    public SlackAttachment author(String name, String link, String iconOrImageLink) {
        this.authorIcon = iconOrImageLink;
        return this.author(name, link);
    }

    public SlackAttachment title(String title) {
        this.title = title;
        return this;
    }

    public SlackAttachment title(String title, String link) {
        this.titleLink = link;
        return this.title(title);
    }

    public SlackAttachment imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public SlackAttachment text(String text) {
        this.text = text;
        return this;
    }

    public SlackAttachment text(SlackMessage message) {
        return this.text(message.toString());
    }

    public SlackAttachment addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public SlackAttachment addMarkdownIn(String markdownin) {
        this.markdown.add(markdownin);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public static class Field {
        @SerializedName(value="title")
        private String title;
        @SerializedName(value="value")
        private String value;
        @SerializedName(value="short")
        private boolean isShort;

        public Field(String title, String value, boolean isShort) {
            this.title = title;
            this.value = value;
            this.isShort = isShort;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isShort() {
            return this.isShort;
        }
    }
}

