/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.io;

import in.ashwanthkumar.utils.io.FileLineIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class IO {
    public static String fromFile(String source) throws IOException {
        return IO.fromFile(new File(source), false);
    }

    public static String fromFile(String source, boolean hasNewLine) throws IOException {
        return IO.fromFile(new File(source), hasNewLine);
    }

    public static String fromFile(File input, boolean hasNewLine) throws IOException {
        String line;
        String EOL = "";
        if (hasNewLine) {
            EOL = "\n";
        }
        StringBuilder contents = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            contents.append(line);
            contents.append(EOL);
        }
        return contents.toString();
    }

    public static Iterator<String> linesFromFile(String source) throws IOException {
        return IO.linesFromFile(new File(source));
    }

    public static Iterator<String> linesFromFile(File source) throws IOException {
        return new FileLineIterator(source);
    }

    public static Iterator<String> linesFromInputStream(InputStream source) throws IOException {
        return new FileLineIterator(source);
    }
}

