/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class FileLineIterator
implements Iterator<String>,
Iterable<String> {
    private BufferedReader reader;
    private String line;

    public FileLineIterator(File input) throws IOException {
        this.reader = new BufferedReader(new FileReader(input));
        this.init();
    }

    public FileLineIterator(InputStream input) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.init();
    }

    private void init() throws IOException {
        this.line = this.reader.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public String next() {
        String valueToReturn = this.line;
        try {
            this.line = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return valueToReturn;
    }

    @Override
    public void remove() {
        throw new RuntimeException("FileLineIterator#remove is not implemented");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

