/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.collections;

import in.ashwanthkumar.utils.func.Function;
import in.ashwanthkumar.utils.func.Predicate;
import in.ashwanthkumar.utils.lang.option.None;
import in.ashwanthkumar.utils.lang.option.Option;
import in.ashwanthkumar.utils.lang.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Lists {
    public static <T> List<T> Nil() {
        return new ArrayList();
    }

    public static <T> List<T> of(T ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <T, U> List<U> map(Iterable<T> collection, Function<T, U> transformation) {
        ArrayList<U> transformed = new ArrayList<U>();
        for (T item : collection) {
            transformed.add(transformation.apply(item));
        }
        return transformed;
    }

    public static <T, U> List<U> map(T[] array, Function<T, U> transformation) {
        return Lists.map(Lists.of(array), transformation);
    }

    public static <T> List<T> filter(Iterable<T> collection, Predicate<T> condition) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (T item : collection) {
            if (!((Boolean)condition.apply(item)).booleanValue()) continue;
            filteredList.add(item);
        }
        return filteredList;
    }

    public static <T, Z> Z foldL(Iterable<T> collection, Z initialValue, Function<Tuple2<Z, T>, Z> foldFunction) {
        Z foldedValue = initialValue;
        for (T item : collection) {
            foldedValue = foldFunction.apply(Tuple2.tuple2(foldedValue, item));
        }
        return foldedValue;
    }

    public static <T> Option<T> find(Iterable<T> collection, Predicate<T> condition) {
        for (T item : collection) {
            if (!((Boolean)condition.apply(item)).booleanValue()) continue;
            return Option.option(item);
        }
        return new None();
    }

    public static <K, T extends Collection<K>> List<K> flatten(Collection<T> elem) {
        ArrayList flattened = new ArrayList();
        for (Collection data : elem) {
            flattened.addAll(data);
        }
        return flattened;
    }

    public static <T> List<T> concat(Collection<T> ... elems) {
        ArrayList<T> concated = new ArrayList<T>();
        for (Collection<T> elem : elems) {
            concated.addAll(elem);
        }
        return concated;
    }

    public static <T> String mkString(Iterable<T> collection) {
        return Lists.mkString(collection, "", "", ",");
    }

    public static <T> String mkString(Iterable<T> collection, String separator) {
        return Lists.mkString(collection, "", "", separator);
    }

    public static <T> String mkString(Iterable<T> collection, String start, String end, String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append(start);
        boolean empty = true;
        for (T elem : collection) {
            builder.append(String.valueOf(elem));
            builder.append(separator);
            builder.append(" ");
            empty = false;
        }
        if (!empty) {
            builder.delete(builder.length() - (separator.length() + 1), builder.length());
        }
        builder.append(end);
        return builder.toString();
    }

    public static <T> List<T> take(Iterable<T> input, int size) {
        ArrayList<T> output = new ArrayList<T>();
        Iterator<T> iterator = input.iterator();
        for (int count = 0; iterator.hasNext() && count < size; ++count) {
            output.add(iterator.next());
        }
        return output;
    }

    public static <T> List<T> takeWhile(Iterable<T> input, Predicate<T> predicate) {
        ArrayList<T> output = new ArrayList<T>();
        for (T elem : input) {
            if (!((Boolean)predicate.apply(elem)).booleanValue()) break;
            output.add(elem);
        }
        return output;
    }
}

