/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.lang.option;

import in.ashwanthkumar.utils.lang.option.None;
import in.ashwanthkumar.utils.lang.option.Some;

public abstract class Option<T> {
    protected T data;

    public Option(T value) {
        this.data = value;
    }

    public T getOrElse(T defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.data;
    }

    public boolean isDefined() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public abstract T get() throws IllegalStateException;

    public static <T> Option<T> option(T value) {
        if (value == null) {
            return new None();
        }
        return new Some<T>(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option option = (Option)o;
        return !(this.data != null ? !this.data.equals(option.data) : option.data != null);
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }
}

