/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.ashwanthkumar.gocd.client.apis.PluginResources;
import in.ashwanthkumar.gocd.client.apis.UserResources;
import in.ashwanthkumar.gocd.client.auth.Authentication;
import in.ashwanthkumar.gocd.client.http.HttpClient;
import in.ashwanthkumar.gocd.client.types.History;
import in.ashwanthkumar.gocd.client.types.Pipeline;
import in.ashwanthkumar.gocd.client.types.PipelineDependency;
import in.ashwanthkumar.gocd.client.types.PipelineRunStatus;
import in.ashwanthkumar.gocd.client.types.PipelineStatus;
import in.ashwanthkumar.gocd.client.types.Stage;
import in.ashwanthkumar.utils.collections.Lists;
import in.ashwanthkumar.utils.lang.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoCD {
    private static Logger LOG = LoggerFactory.getLogger(GoCD.class);
    private HttpClient client;
    private UserResources users;
    private PluginResources plugins;

    public GoCD(HttpClient client) {
        this.client = client;
        this.users = new UserResources(this.client);
        this.plugins = new PluginResources(this.client);
    }

    public GoCD(String server, Authentication authenticationMechanism) {
        this(new HttpClient(authenticationMechanism, server));
    }

    @Deprecated(since="0.0.8", forRemoval=true)
    public GoCD(String server, String username, String password) {
        this(new HttpClient(username, password, server));
    }

    GoCD(String server, String username, String password, String mockResponse) {
        this(server, username, password);
        this.client.setMockResponse(mockResponse);
    }

    GoCD(String server, Authentication authentication, String mockResponse) {
        this(server, authentication);
        this.client.setMockResponse(mockResponse);
    }

    public List<String> allPipelineNames(String pipelinePrefix) throws IOException {
        String xml = this.client.getXML("/go/api/pipelines.xml");
        Document doc = Jsoup.parse((String)xml);
        Elements pipelineElements = doc.select("pipeline[href]");
        Stream<String> pipelines = pipelineElements.stream().map(element -> {
            String href = element.attr("href");
            String apiPrefix = "/go/api/pipelines/";
            return href.substring(href.indexOf(apiPrefix) + apiPrefix.length(), href.indexOf("/stages.xml"));
        }).filter(s -> StringUtils.isEmpty((String)pipelinePrefix) || s.startsWith(pipelinePrefix));
        return pipelines.collect(Collectors.toList());
    }

    public List<PipelineDependency> upstreamDependencies(String pipeline, int version) throws IOException {
        JsonObject result = this.client.getRawJson("/go/pipelines/value_stream_map/" + pipeline + "/" + version + ".json").getAsJsonObject();
        List dependencies = Lists.of((Object[])new PipelineDependency[]{new PipelineDependency(pipeline, version)});
        if (!result.has("levels")) {
            return dependencies;
        }
        JsonArray levels = result.getAsJsonArray("levels");
        for (JsonElement level : levels) {
            JsonArray nodes = level.getAsJsonObject().getAsJsonArray("nodes");
            for (JsonElement node : nodes) {
                JsonObject nodeObj = node.getAsJsonObject();
                String name = nodeObj.get("name").getAsString();
                if (name.equals(pipeline)) {
                    return dependencies;
                }
                if (!nodeObj.get("node_type").getAsString().equalsIgnoreCase("PIPELINE")) continue;
                JsonArray instances = nodeObj.getAsJsonArray("instances");
                for (JsonElement instance : instances) {
                    int counter = instance.getAsJsonObject().get("counter").getAsInt();
                    dependencies.add(new PipelineDependency().setPipelineName(name).setVersion(counter));
                }
            }
        }
        return dependencies;
    }

    public PipelineStatus pipelineStatus(String pipeline) throws IOException {
        return this.client.getAs("/go/api/pipelines/" + pipeline + "/status", PipelineStatus.class);
    }

    public Pipeline pipelineInstance(String pipeline, int pipelineCounter) throws IOException {
        return this.client.getAs("/go/api/pipelines/" + pipeline + "/instance/" + pipelineCounter, Pipeline.class);
    }

    public History pipelineHistory(String pipeline) throws IOException {
        return this.pipelineHistory(pipeline, 0);
    }

    public History pipelineHistory(String pipeline, int offset) throws IOException {
        return this.client.getAs("/go/api/pipelines/" + pipeline + "/history/" + offset, History.class);
    }

    public Map<Integer, PipelineRunStatus> pipelineRunStatus(String pipeline) throws IOException {
        return this.pipelineRunStatus(pipeline, 0);
    }

    public Map<Integer, PipelineRunStatus> pipelineRunStatus(String pipelineName, int offset) throws IOException {
        TreeMap<Integer, PipelineRunStatus> result = new TreeMap<Integer, PipelineRunStatus>(Collections.reverseOrder());
        History history = this.pipelineHistory(pipelineName, offset);
        for (Pipeline pipeline : history.getPipelines()) {
            if (pipeline.isPreparingToSchedule()) continue;
            PipelineRunStatus status = this.pipelineStatusFrom(pipeline.getStages());
            LOG.debug(pipeline + "@" + pipeline.getCounter() + " has " + status);
            result.put(pipeline.getCounter(), status);
        }
        return result;
    }

    private PipelineRunStatus pipelineStatusFrom(List<Stage> stages) {
        for (Stage stage : stages) {
            boolean stageFailed = StringUtils.isEmpty((String)stage.getResult()) || stage.getResult().equalsIgnoreCase("failed");
            if (!stageFailed) continue;
            return PipelineRunStatus.FAILED;
        }
        return PipelineRunStatus.PASSED;
    }

    public UserResources users() {
        return this.users;
    }

    public PluginResources plugins() {
        return this.plugins;
    }
}

