/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.http;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.ObjectParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import in.ashwanthkumar.gocd.client.http.GsonObjectParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static final int SOCKET_TIMEOUT = 600000;
    private static final int READ_TIMEOUT = 600000;
    private String mockResponse;
    private final HttpRequestFactory requestFactory;

    public HttpClient(String username, String password, Proxy proxy) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        this.requestFactory = builder.build().createRequestFactory((HttpRequestInitializer)new BasicAuthentication(username, password));
    }

    public HttpClient(String username, String password) {
        this(username, password, null);
    }

    public void setMockResponse(String response) {
        this.mockResponse = response;
    }

    public JsonElement getRawJson(String url) throws IOException {
        if (this.mockResponse != null) {
            return new JsonParser().parse(this.mockResponse);
        }
        return new JsonParser().parse(this.invokeGET(url).execute().parseAsString());
    }

    public <T> T getAs(String url, Class<T> type) throws IOException {
        if (this.mockResponse != null) {
            return new GsonObjectParser(new Gson()).parseAndClose((Reader)new StringReader(this.mockResponse), type);
        }
        return (T)this.invokeGET(url).setParser((ObjectParser)new GsonObjectParser(new Gson())).execute().parseAs(type);
    }

    public String getXML(String url) throws IOException {
        if (this.mockResponse != null) {
            return this.mockResponse;
        }
        HttpResponse response = this.requestFactory.buildGetRequest(new GenericUrl(url)).execute();
        return response.parseAsString();
    }

    public HttpRequest invokeGET(String url) throws IOException {
        LOG.debug("Hitting " + url);
        return this.requestFactory.buildGetRequest(new GenericUrl(url)).setConnectTimeout(600000).setReadTimeout(600000);
    }
}

