/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.types;

import com.google.gson.annotations.SerializedName;
import in.ashwanthkumar.gocd.client.types.Job;
import in.ashwanthkumar.utils.collections.Lists;
import in.ashwanthkumar.utils.func.Function;
import java.util.List;

public class Stage {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="counter")
    private int counter;
    @SerializedName(value="result")
    private String result;
    @SerializedName(value="approved_by")
    private String approvedBy;
    @SerializedName(value="jobs")
    private List<Job> jobs;

    public Stage() {
    }

    public Stage(int id, String name, int counter, String result, String approvedBy, List<Job> jobs) {
        this.id = id;
        this.name = name;
        this.counter = counter;
        this.result = result;
        this.approvedBy = approvedBy;
        this.jobs = jobs;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCounter() {
        return this.counter;
    }

    public String getResult() {
        return this.result;
    }

    public String getApprovedBy() {
        return this.approvedBy;
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public List<String> jobNames() {
        return Lists.map(this.jobs, (Function)new Function<Job, String>(){

            public String apply(Job input) {
                return input.name;
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stage stage = (Stage)o;
        if (this.id != stage.id) {
            return false;
        }
        if (this.counter != stage.counter) {
            return false;
        }
        if (this.name != null ? !this.name.equals(stage.name) : stage.name != null) {
            return false;
        }
        if (this.result != null ? !this.result.equals(stage.result) : stage.result != null) {
            return false;
        }
        if (this.approvedBy != null ? !this.approvedBy.equals(stage.approvedBy) : stage.approvedBy != null) {
            return false;
        }
        return !(this.jobs == null ? stage.jobs != null : !this.jobs.equals(stage.jobs));
    }

    public int hashCode() {
        int result1 = this.id;
        result1 = 31 * result1 + (this.name != null ? this.name.hashCode() : 0);
        result1 = 31 * result1 + this.counter;
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        result1 = 31 * result1 + (this.approvedBy != null ? this.approvedBy.hashCode() : 0);
        result1 = 31 * result1 + (this.jobs != null ? this.jobs.hashCode() : 0);
        return result1;
    }
}

