/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.types;

import com.google.gson.annotations.SerializedName;
import in.ashwanthkumar.gocd.client.GoCD;
import in.ashwanthkumar.gocd.client.types.BuildCause;
import in.ashwanthkumar.gocd.client.types.MaterialRevision;
import in.ashwanthkumar.gocd.client.types.Stage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

public class Pipeline {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="counter")
    private int counter;
    @SerializedName(value="preparing_to_schedule")
    private boolean preparingToSchedule;
    @SerializedName(value="can_run")
    private boolean canRun;
    @SerializedName(value="build_cause")
    private BuildCause buildCause;
    @SerializedName(value="stages")
    private List<Stage> stages;
    @SerializedName(value="label")
    private String label;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isPreparingToSchedule() {
        return this.preparingToSchedule;
    }

    public boolean isCanRun() {
        return this.canRun;
    }

    public BuildCause getBuildCause() {
        return this.buildCause;
    }

    public List<Stage> getStages() {
        return this.stages;
    }

    public String getLabel() {
        return this.label;
    }

    public List<MaterialRevision> rootChanges(GoCD client) throws MalformedURLException, IOException {
        ArrayList<MaterialRevision> result = new ArrayList<MaterialRevision>();
        this.addChangesRecursively(client, result);
        return result;
    }

    void addChangesRecursively(GoCD client, List<MaterialRevision> outChanges) throws MalformedURLException, IOException {
        for (MaterialRevision mr : this.buildCause.getMaterialRevisions()) {
            mr.addChangesRecursively(client, outChanges);
        }
    }

    public String toString() {
        if (this.stages != null && this.stages.size() > 0) {
            return this.name + "/" + this.counter + "/" + this.stages.get(0).getName() + "/" + this.stages.get(0).getResult();
        }
        return this.name + "/" + this.counter;
    }
}

