/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.model;

import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.model.GeoAttributes;
import java.net.InetAddress;

public final class GeoAttributesImpl
implements GeoAttributes {
    private final String city;
    private final String country;
    private final String province;
    private final String countryCode;
    private final String isp;
    private final InetAddress startInetAddress;
    private final InetAddress endInetAddress;
    private final String district;
    private final String zipCode;
    private final Double lat;
    private final Double lng;
    private final String timezone;
    private final String connectionType;
    private final String org;

    private GeoAttributesImpl(Builder builder) {
        this.startInetAddress = builder.startInetAddress;
        this.endInetAddress = builder.endInetAddress;
        this.city = builder.city;
        this.country = builder.country;
        this.province = builder.province;
        this.countryCode = builder.countryCode;
        this.isp = builder.isp;
        this.district = builder.district;
        this.zipCode = builder.zipCode;
        this.lat = builder.lat;
        this.lng = builder.lng;
        this.timezone = builder.timezone;
        this.connectionType = builder.connectionType;
        this.org = builder.org;
    }

    @Override
    public InetAddress getStartInetAddress() {
        return this.startInetAddress;
    }

    @Override
    public InetAddress getEndInetAddress() {
        return this.endInetAddress;
    }

    @Override
    public GeoEntity getGeoEntity() {
        return new GeoEntity.Builder().withCity(this.city).withCountry(this.country).withCountryCode(this.countryCode).withProvince(this.province).withIsp(this.isp).withDistrict(this.district).withConnType(this.connectionType).withZipCode(this.zipCode).withLat(this.lat).withLng(this.lng).withTimezone(this.timezone).withOrg(this.org).build();
    }

    public static class Builder {
        private InetAddress startInetAddress;
        private InetAddress endInetAddress;
        private String city;
        private String country;
        private String province;
        private String countryCode;
        private String isp;
        private String district;
        private String zipCode;
        private Double lat;
        private Double lng;
        private String timezone;
        private String connectionType;
        private String org;

        public Builder withDistrict(String district) {
            this.district = district;
            return this;
        }

        public Builder withConnType(String connType) {
            this.connectionType = connType;
            return this;
        }

        public Builder withZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder withLat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Builder withLng(Double lng) {
            this.lng = lng;
            return this;
        }

        public Builder withTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder withOrg(String org) {
            this.org = org;
            return this;
        }

        public Builder withIsp(String isp) {
            this.isp = isp;
            return this;
        }

        public Builder withStartInetAddress(InetAddress startInetAddress) {
            this.startInetAddress = startInetAddress;
            return this;
        }

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withEndInetAddress(InetAddress endInetAddress) {
            this.endInetAddress = endInetAddress;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withProvince(String province) {
            this.province = province;
            return this;
        }

        public GeoAttributesImpl build() {
            return new GeoAttributesImpl(this);
        }
    }
}

