/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.lookup;

import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.lookup.GeoEntityLookupService;
import in.ankushs.dbip.repository.DbIpRepository;
import in.ankushs.dbip.repository.JavaMapDbIpRepositoryImpl;
import in.ankushs.dbip.utils.PreConditions;
import java.net.InetAddress;

public final class GeoEntityLookupServiceImpl
implements GeoEntityLookupService {
    private static final String UNKNOWN = "Unknown";
    private final DbIpRepository repository = JavaMapDbIpRepositoryImpl.getInstance();
    private static GeoEntityLookupServiceImpl instance = null;

    private GeoEntityLookupServiceImpl() {
    }

    public static GeoEntityLookupServiceImpl getInstance() {
        if (instance == null) {
            return new GeoEntityLookupServiceImpl();
        }
        return instance;
    }

    @Override
    public GeoEntity lookup(InetAddress inetAddress) {
        PreConditions.checkNull(inetAddress, "inetAddress cannot be null ");
        GeoEntity geoEntity = this.repository.get(inetAddress);
        if (geoEntity == null) {
            geoEntity = new GeoEntity.Builder().withCity(UNKNOWN).withCountry(UNKNOWN).withCountryCode(UNKNOWN).withProvince(UNKNOWN).build();
        }
        return geoEntity;
    }
}

