/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.repository;

import com.google.common.net.InetAddresses;
import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.model.GeoAttributes;
import in.ankushs.dbip.repository.DbIpRepository;
import in.ankushs.dbip.utils.PreConditions;
import java.net.InetAddress;
import java.util.TreeMap;

public final class JavaMapDbIpRepositoryImpl
implements DbIpRepository {
    private static JavaMapDbIpRepositoryImpl instance = null;
    private static final TreeMap<Integer, GeoEntity> repository = new TreeMap();

    private JavaMapDbIpRepositoryImpl() {
    }

    public static JavaMapDbIpRepositoryImpl getInstance() {
        if (instance == null) {
            return new JavaMapDbIpRepositoryImpl();
        }
        return instance;
    }

    @Override
    public GeoEntity get(InetAddress inetAddress) {
        PreConditions.checkNull(inetAddress, "inetAddress must not be null");
        Integer startIpNum = InetAddresses.coerceToInteger((InetAddress)inetAddress);
        return repository.floorEntry(startIpNum) == null ? null : repository.floorEntry(startIpNum).getValue();
    }

    @Override
    public void save(GeoAttributes geoAttributes) {
        PreConditions.checkNull(geoAttributes, "geoAttributes must not be null");
        Integer startIpNum = InetAddresses.coerceToInteger((InetAddress)geoAttributes.getStartIp());
        GeoEntity geoEntity = geoAttributes.getGeoEntity();
        repository.put(startIpNum, geoEntity);
    }
}

