/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.model;

import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.model.GeoAttributes;
import java.net.InetAddress;

public final class GeoAttributesImpl
implements GeoAttributes {
    private final InetAddress startIp;
    private final InetAddress endIp;
    private final String city;
    private final String country;
    private final String province;

    private GeoAttributesImpl(Builder builder) {
        this.startIp = builder.startIp;
        this.endIp = builder.endIp;
        this.city = builder.city;
        this.country = builder.country;
        this.province = builder.province;
    }

    @Override
    public InetAddress getStartIp() {
        return this.startIp;
    }

    @Override
    public InetAddress getEndIp() {
        return this.endIp;
    }

    @Override
    public GeoEntity getGeoEntity() {
        return new GeoEntity.Builder().withCity(this.city).withCountry(this.country).withProvince(this.province).build();
    }

    public static class Builder {
        private InetAddress startIp;
        private InetAddress endIp;
        private String city;
        private String country;
        private String province;

        public Builder withStartIp(InetAddress startIp) {
            this.startIp = startIp;
            return this;
        }

        public Builder withEndIp(InetAddress endIp) {
            this.endIp = endIp;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withProvince(String province) {
            this.province = province;
            return this;
        }

        public GeoAttributesImpl build() {
            return new GeoAttributesImpl(this);
        }
    }
}

