/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

public enum Format {
    PNG("svg", true, true){

        @Override
        String postProcess(String result) {
            return Format.postProcessSvg(result);
        }
    }
    ,
    SVG("svg", false, true){

        @Override
        String postProcess(String result) {
            return Format.postProcessSvg(result);
        }
    }
    ,
    SVG_STANDALONE("svg", false, true),
    XDOT("xdot", false, false),
    PLAIN("plain", false, false),
    PS("ps", false, false),
    JSON("json", false, false);

    final String vizName;
    final boolean image;
    final boolean svg;

    private Format(String vizName, boolean image, boolean svg) {
        this.vizName = vizName;
        this.image = image;
        this.svg = svg;
    }

    String postProcess(String result) {
        return result;
    }

    private static String postProcessSvg(String result) {
        int pos = result.indexOf("<svg ");
        return pos < 0 ? result : result.substring(pos);
    }
}

