/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.GraphvizEngine;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphvizEngine
implements GraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    private final boolean sync;

    public AbstractGraphvizEngine(boolean sync) {
        this.sync = sync;
    }

    @Override
    public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        if (this.sync) {
            this.initTask(onOk, onError);
        } else {
            new Thread(() -> this.initTask(onOk, onError)).start();
        }
    }

    private void initTask(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        try {
            this.doInit();
            onOk.accept(this);
        }
        catch (Exception e) {
            LOG.info("Could not initialize {}", (Object)this, (Object)e);
            this.release();
            onError.accept(this);
        }
    }

    @Override
    public void release() {
    }

    protected abstract void doInit() throws Exception;

    public String toString() {
        return this.getClass().getName();
    }
}

