/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Linkable;
import guru.nidi.graphviz.model.MutableLinkSource;
import guru.nidi.graphviz.model.MutableNodePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MutableNode
implements Linkable,
MutableAttributed<MutableNode>,
LinkTarget,
MutableLinkSource<MutableNode> {
    protected Label label;
    protected final List<Link> links;
    protected final MutableAttributed<MutableNode> attributes;

    MutableNode() {
        this(null, new ArrayList<Link>(), Attributes.attrs(new Attributes[0]));
    }

    protected MutableNode(Label label, List<Link> links, Attributes attributes) {
        this.label = label;
        this.links = links;
        this.attributes = new SimpleMutableAttributed<MutableNode>(this, attributes);
        CreationContext.current().ifPresent(ctx -> ctx.nodes().applyTo(attributes));
    }

    public MutableNode copy() {
        return new MutableNode(this.label, new ArrayList<Link>(this.links), this.attributes.applyTo(Attributes.attrs(new Attributes[0])));
    }

    public MutableNode setLabel(Label label) {
        this.label = label;
        return this;
    }

    public MutableNode setLabel(String name) {
        return this.setLabel(Label.of(name));
    }

    public MutableNode merge(MutableNode n) {
        this.links.addAll(n.links);
        this.attributes.add((Attributes)n.attributes);
        return this;
    }

    public MutableNodePoint withRecord(String record) {
        return new MutableNodePoint().setNode(this).setRecord(record);
    }

    public MutableNodePoint withCompass(Compass compass) {
        return new MutableNodePoint().setNode(this).setCompass(compass);
    }

    @Override
    public MutableNode addLink(LinkTarget target) {
        Link link = target.linkTo();
        this.links.add(Link.between(this.from(link), link.to).with((Attributes)link.attributes));
        return this;
    }

    public MutableNode addLink(LinkTarget ... targets) {
        for (LinkTarget target : targets) {
            this.addLink(target);
        }
        return this;
    }

    public MutableNode addLink(String node) {
        return this.addLink((LinkTarget)new MutableNode().setLabel(node));
    }

    public MutableNode addLink(String ... nodes) {
        for (String node : nodes) {
            this.addLink(node);
        }
        return this;
    }

    @Override
    public MutableNode add(Attributes attrs) {
        this.attributes.add(attrs);
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.attributes.iterator();
    }

    @Override
    public Attributes applyTo(MapAttributes attrs) {
        return this.attributes.applyTo(attrs);
    }

    private MutableNodePoint from(Link link) {
        if (link.from instanceof MutableNodePoint) {
            MutableNodePoint f = (MutableNodePoint)link.from;
            return new MutableNodePoint().setNode(this).setRecord(f.record()).setCompass(f.compass());
        }
        return new MutableNodePoint().setNode(this);
    }

    public Label label() {
        return this.label;
    }

    @Override
    public Collection<Link> links() {
        return this.links;
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    public MutableAttributed<MutableNode> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNode node = (MutableNode)o;
        if (this.label != null ? !this.label.equals(node.label) : node.label != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(node.links) : node.links != null) {
            return false;
        }
        return !(this.attributes == null ? node.attributes != null : !this.attributes.equals(node.attributes));
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.label + this.attributes.toString() + "->" + this.links.stream().map(l -> l.to.toString()).collect(Collectors.joining(","));
    }
}

