/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;

final class Options {
    final Engine engine;
    final Format format;
    final Integer totalMemory;

    private Options(Engine engine, Format format, Integer totalMemory) {
        this.engine = engine;
        this.format = format;
        this.totalMemory = totalMemory;
    }

    public static Options create() {
        return new Options(Engine.DOT, null, null);
    }

    public Options engine(Engine engine) {
        return new Options(engine, this.format, this.totalMemory);
    }

    public Options format(Format format) {
        return new Options(this.engine, format, this.totalMemory);
    }

    public Options totalMemory(int totalMemory) {
        return new Options(this.engine, this.format, totalMemory);
    }

    public String toJson() {
        String form = "format:'" + this.format.vizName + "'";
        String eng = ",engine:'" + this.engine.toString().toLowerCase() + "'";
        String mem = this.totalMemory == null ? "" : ",totalMemory:'" + this.totalMemory + "'";
        return "{" + form + eng + mem + "}";
    }
}

