/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.NamedLocation;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.pmd.PmdUtils;
import guru.nidi.codeassert.util.ListUtils;
import java.util.List;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleViolation;

public class PmdViolationCollector
extends BaseCollector<RuleViolation, Ignore, PmdViolationCollector> {
    private final RulePriority minPriority;

    public PmdViolationCollector() {
        this(null);
    }

    private PmdViolationCollector(RulePriority minPriority) {
        this.minPriority = minPriority;
    }

    public PmdViolationCollector minPriority(RulePriority minPriority) {
        return new PmdViolationCollector(minPriority);
    }

    @Override
    public PmdViolationCollector config(final CollectorConfig<Ignore> ... configs) {
        return new PmdViolationCollector(this.minPriority){

            @Override
            public ActionResult accept(RuleViolation issue) {
                return this.accept(issue, PmdViolationCollector.this, configs);
            }

            @Override
            public String toString() {
                return PmdViolationCollector.this.toString() + "\n" + ListUtils.join("\n", configs);
            }
        };
    }

    @Override
    public ActionResult accept(RuleViolation issue) {
        int issuePrio = issue.getRule().getPriority().getPriority();
        return new ActionResult(this.minPriority == null || issuePrio <= this.minPriority.getPriority(), null, 1);
    }

    @Override
    protected ActionResult doAccept(RuleViolation issue, Ignore action) {
        Language language = Language.byFilename(issue.getFilename());
        return action.accept(new NamedLocation(issue.getRule().getName(), language, PmdUtils.className(issue), issue.getMethodName(), true));
    }

    @Override
    public List<Ignore> unused(UsageCounter counter) {
        return this.unusedNullAction(counter, this.minPriority != null);
    }

    public String toString() {
        return this.minPriority == null ? "" : "Priority >= " + this.minPriority + " ";
    }
}

