/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodeClassBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SourceFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(SourceFileParser.class);
    static final String SLASH_SLASH = "//";
    static final String QUOTE = "\"";
    static final String TRIPLE_QUOTE = "\"\"\"";
    static final String SLASH_STAR = "/*";
    static final String STAR_SLASH = "*/";
    State state;
    String line;
    int pos;
    String token;
    int codeLines;
    int commentLines;
    int emptyLines;
    int totalLines;

    SourceFileParser() {
    }

    static CodeClass parse(CodeClass clazz, File file, Charset charset) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Language language = Language.byFilename(file.getName());
            if (language == null) {
                LOG.info("Unknown source file type {}. Ignoring it", (Object)file);
            } else {
                SourceFileParser.parse(clazz, language, in, charset);
            }
            CodeClass codeClass = clazz;
            return codeClass;
        }
    }

    static CodeClass parse(CodeClass clazz, Language language, InputStream is, Charset charset) throws IOException {
        try (InputStreamReader in = new InputStreamReader(is, charset);){
            CodeClass codeClass = SourceFileParser.parse(clazz, language, in);
            return codeClass;
        }
    }

    static CodeClass parse(CodeClass clazz, Language language, Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            SourceFileParser parser = SourceFileParser.parser(language);
            if (parser == null) {
                LOG.info("No parser for language {}. Ignoring it", (Object)language);
            } else {
                parser.parse(in);
                new CodeClassBuilder(clazz).addSourceSizes(parser.codeLines, parser.commentLines, parser.emptyLines, parser.totalLines);
            }
            CodeClass codeClass = clazz;
            return codeClass;
        }
    }

    private static SourceFileParser parser(Language language) {
        switch (language) {
            case JAVA: {
                return new JavaParser();
            }
            case KOTLIN: {
                return new KotlinParser();
            }
        }
        return null;
    }

    void parse(BufferedReader in) throws IOException {
        this.state = State.CODE;
        while ((this.line = in.readLine()) != null) {
            this.pos = 0;
            ++this.totalLines;
            if (this.line.trim().length() == 0) {
                ++this.emptyLines;
            }
            this.parseLine();
            if (this.state != State.LINE_COMMENT && this.state != State.LINE_STRING) continue;
            this.state = State.CODE;
        }
    }

    void parseLine() {
        boolean comment = this.state == State.COMMENT;
        boolean code = false;
        do {
            this.doParse();
            code |= !comment && this.pos > 2 || this.state != State.COMMENT && this.state != State.LINE_COMMENT && (!comment || this.pos < this.line.length());
            comment |= this.state == State.COMMENT || this.state == State.LINE_COMMENT;
        } while (this.pos > 0 && this.pos < this.line.length());
        if (comment) {
            ++this.commentLines;
        }
        if (code) {
            ++this.codeLines;
        }
    }

    protected boolean findToken(String ... tokens) {
        int tp = -1;
        for (String tok : tokens) {
            int index = this.line.indexOf(tok, this.pos);
            if (index < 0 || tp >= 0 && index >= tp) continue;
            this.token = tok;
            tp = index;
        }
        if (tp < 0) {
            this.pos = -1;
            return false;
        }
        this.pos = tp + this.token.length();
        return true;
    }

    protected abstract void doParse();

    static class KotlinParser
    extends SourceFileParser {
        private int nesting;

        KotlinParser() {
        }

        @Override
        public void doParse() {
            if (this.findToken(SourceFileParser.SLASH_SLASH, SourceFileParser.SLASH_STAR, SourceFileParser.STAR_SLASH, SourceFileParser.TRIPLE_QUOTE, SourceFileParser.QUOTE)) {
                if (this.state == State.COMMENT || this.state == State.LINE_COMMENT) {
                    if (this.token.equals(SourceFileParser.STAR_SLASH)) {
                        --this.nesting;
                        if (this.nesting == 0) {
                            this.state = State.CODE;
                        }
                    } else if (this.token.equals(SourceFileParser.SLASH_STAR)) {
                        this.state = State.COMMENT;
                        ++this.nesting;
                    }
                } else if (this.state == State.STRING) {
                    if (this.token.equals(SourceFileParser.TRIPLE_QUOTE)) {
                        this.state = State.CODE;
                    }
                } else if (this.token.equals(SourceFileParser.TRIPLE_QUOTE)) {
                    this.state = State.STRING;
                } else if (this.state == State.LINE_STRING) {
                    if (this.token.equals(SourceFileParser.QUOTE) && (this.pos == 0 || this.line.charAt(this.pos - 2) != '\\')) {
                        this.state = State.CODE;
                    }
                } else if (this.token.equals(SourceFileParser.QUOTE)) {
                    this.state = State.LINE_STRING;
                } else if (this.token.equals(SourceFileParser.SLASH_STAR)) {
                    this.state = State.COMMENT;
                    ++this.nesting;
                } else if (this.token.equals(SourceFileParser.SLASH_SLASH)) {
                    this.state = State.LINE_COMMENT;
                }
            }
        }
    }

    static class JavaParser
    extends SourceFileParser {
        JavaParser() {
        }

        @Override
        public void doParse() {
            if (this.findToken(SourceFileParser.SLASH_SLASH, SourceFileParser.SLASH_STAR, SourceFileParser.STAR_SLASH, SourceFileParser.QUOTE)) {
                if (this.state == State.COMMENT || this.state == State.LINE_COMMENT) {
                    if (this.token.equals(SourceFileParser.STAR_SLASH)) {
                        this.state = State.CODE;
                    }
                } else if (this.state == State.LINE_STRING) {
                    if (this.token.equals(SourceFileParser.QUOTE) && (this.pos == 0 || this.line.charAt(this.pos - 2) != '\\')) {
                        this.state = State.CODE;
                    }
                } else if (this.token.equals(SourceFileParser.QUOTE)) {
                    this.state = State.LINE_STRING;
                } else if (this.token.equals(SourceFileParser.SLASH_STAR)) {
                    this.state = State.COMMENT;
                } else if (this.token.equals(SourceFileParser.SLASH_SLASH)) {
                    this.state = State.LINE_COMMENT;
                }
            }
        }
    }

    static enum State {
        CODE,
        STRING,
        LINE_STRING,
        COMMENT,
        LINE_COMMENT;

    }
}

