/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.UsingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CodePackage
extends UsingElement<CodePackage> {
    private final String name;
    private final Set<CodeClass> classes;
    private final List<CodePackage> uses;
    private final Set<CodeClass> annotations;

    CodePackage(String name) {
        this.name = name;
        this.classes = new HashSet<CodeClass>();
        this.uses = new ArrayList<CodePackage>();
        this.annotations = new HashSet<CodeClass>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addClass(CodeClass clazz) {
        this.classes.add(clazz);
    }

    public void addAnnotation(CodeClass clazz) {
        this.annotations.add(clazz);
    }

    public Collection<CodeClass> getClasses() {
        return this.classes;
    }

    public Collection<CodeClass> getAnnotations() {
        return this.annotations;
    }

    void addEfferent(CodePackage jPackage) {
        if (!jPackage.getName().equals(this.getName()) && !this.uses.contains(jPackage)) {
            this.uses.add(jPackage);
        }
    }

    public Set<String> usedVia(UsingElement<CodePackage> to) {
        HashSet<String> res = new HashSet<String>();
        for (CodeClass jc : this.getClasses()) {
            if (!jc.uses(to.self())) continue;
            res.add(jc.getName());
        }
        return res;
    }

    @Override
    public String getPackageName() {
        return this.name;
    }

    @Override
    public boolean isMatchedBy(LocationMatcher matcher) {
        return matcher.matchesPackage(this.name);
    }

    @Override
    public CodePackage self() {
        return this;
    }

    @Override
    public Collection<CodePackage> uses() {
        return this.uses;
    }

    public boolean equals(Object other) {
        if (other instanceof CodePackage) {
            CodePackage otherPackage = (CodePackage)other;
            return otherPackage.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.name;
    }
}

