/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.model.AttributeInfo;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodePackage;
import guru.nidi.codeassert.model.Constant;
import guru.nidi.codeassert.model.ConstantPool;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.model.SignatureParser;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;

class CodeClassBuilder {
    private static final char CLASS_DESCRIPTOR = 'L';
    private static final char TYPE_END = ';';
    final CodeClass clazz;
    private final Model model;
    private final ConstantPool constantPool;

    private CodeClassBuilder(CodeClass clazz, Model model, ConstantPool constantPool) {
        this.clazz = clazz;
        this.model = model;
        this.constantPool = constantPool;
    }

    CodeClassBuilder(String className, Model model, ConstantPool constantPool) {
        this(model.getOrCreateClass(className), model, constantPool);
    }

    CodeClassBuilder(CodeClass clazz) {
        this(clazz, null, null);
    }

    public CodeClassBuilder addSuperClass(String className) {
        this.addImport(className);
        return this;
    }

    public CodeClassBuilder addInterfaces(List<String> interfaceNames) {
        for (String interfaceName : interfaceNames) {
            this.addImport(interfaceName);
        }
        return this;
    }

    public CodeClassBuilder addClassConstantReferences() throws IOException {
        for (Constant constant : this.constantPool) {
            if (constant.tag != 7) continue;
            String name = this.constantPool.getUtf8(constant.nameIndex);
            this.addImport(name);
        }
        return this;
    }

    public CodeClassBuilder addFlags(int flags) {
        this.clazz.concrete = !Modifier.isAbstract(flags) && !Modifier.isInterface(flags);
        return this;
    }

    public CodeClassBuilder addMethodRefs(List<MemberInfo> methods) throws IOException {
        this.addMemberAnnotationRefs(methods);
        this.addMemberSignatureRefs(SignatureParser.Source.METHOD, methods);
        this.addMemberTypes(methods);
        this.clazz.methods.addAll(methods);
        return this;
    }

    public CodeClassBuilder addFieldRefs(List<MemberInfo> fields) throws IOException {
        this.addMemberAnnotationRefs(fields);
        this.addMemberSignatureRefs(SignatureParser.Source.FIELD, fields);
        this.addMemberTypes(fields);
        this.clazz.fields.addAll(fields);
        return this;
    }

    public CodeClassBuilder addAttributeRefs(List<AttributeInfo> attributes) throws IOException {
        for (AttributeInfo attribute : attributes) {
            this.addSourceAttribute(attribute);
            this.addAttributeAnnotationRefs(attribute);
            this.addAttributeSignatureRefs(attribute);
        }
        return this;
    }

    public CodeClassBuilder addPackageInfo(Model model, String className) {
        if (className.endsWith(".package-info")) {
            CodePackage pack = model.getOrCreatePackage(Model.packageOf(className));
            for (CodeClass ann : this.clazz.getAnnotations()) {
                pack.addAnnotation(ann);
            }
        }
        return this;
    }

    public CodeClassBuilder addCodeSizes(int totalSize, List<MemberInfo> methods) {
        int codeSize = 0;
        for (MemberInfo method : methods) {
            codeSize += method.codeSize;
        }
        this.clazz.codeSize = codeSize;
        this.clazz.totalSize = totalSize;
        return this;
    }

    public CodeClassBuilder addSourceSizes(int codeLines, int commentLines, int emptyLines, int totalLines) {
        this.clazz.codeLines = codeLines;
        this.clazz.commentLines = commentLines;
        this.clazz.emptyLines = emptyLines;
        this.clazz.totalLines = totalLines;
        return this;
    }

    private void addMemberAnnotationRefs(List<MemberInfo> infos) throws IOException {
        for (MemberInfo info : infos) {
            if (info.annotations == null) continue;
            this.addAnnotationReferences(info.annotations);
        }
    }

    private void addMemberSignatureRefs(SignatureParser.Source source, List<MemberInfo> infos) throws IOException {
        for (MemberInfo info : infos) {
            if (info.signature == null) continue;
            String name = this.constantPool.getUtf8(this.u2(info.signature.value, 0));
            for (String clazz : SignatureParser.parseSignature(source, name).getClasses()) {
                this.addImport(clazz);
            }
        }
    }

    private void addMemberTypes(List<MemberInfo> infos) {
        for (MemberInfo info : infos) {
            String[] types;
            for (String type : types = this.descriptorToTypes(info.descriptor)) {
                if (type.length() <= 0) continue;
                this.addImport(type);
            }
        }
    }

    private void addSourceAttribute(AttributeInfo attribute) throws IOException {
        if (attribute.isSource()) {
            this.clazz.sourceFile = attribute.sourceFile(this.constantPool);
        }
    }

    private void addAttributeSignatureRefs(AttributeInfo attribute) throws IOException {
        if (attribute.isSignature()) {
            String name = this.constantPool.getUtf8(this.u2(attribute.value, 0));
            for (String clazz : SignatureParser.parseSignature(SignatureParser.Source.CLASS, name).getClasses()) {
                this.addImport(clazz);
            }
        }
    }

    private void addAttributeAnnotationRefs(AttributeInfo attribute) throws IOException {
        if (attribute.isAnnotation()) {
            this.addAnnotationReferences(attribute);
        }
    }

    private void addAnnotationReferences(AttributeInfo annotation) throws IOException {
        byte[] data = annotation.value;
        int numAnnotations = this.u2(data, 0);
        this.addAnnotationReferences(data, 2, numAnnotations);
    }

    private int addAnnotationReferences(byte[] data, int index, int numAnnotations) throws IOException {
        int i = index;
        for (int a = 0; a < numAnnotations; ++a) {
            int typeIndex = this.u2(data, i);
            int elements = this.u2(data, i += 2);
            i += 2;
            this.clazz.addAnnotation(this.getTypeName(this.descriptorToType(this.constantPool.getUtf8(typeIndex))), this.model);
            for (int e = 0; e < elements; ++e) {
                i = this.addAnnotationElementValueReferences(data, i + 2);
            }
        }
        return i;
    }

    private int addAnnotationElementValueReferences(byte[] data, int i) throws IOException {
        byte tag = data[i];
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return i + 3;
            }
            case 101: {
                int enumTypeIndex = this.u2(data, i + 1);
                this.addImport(this.descriptorToType(this.constantPool.getUtf8(enumTypeIndex)));
                return i + 5;
            }
            case 99: {
                int classInfoIndex = this.u2(data, i + 1);
                this.addImport(this.descriptorToType(this.constantPool.getUtf8(classInfoIndex)));
                return i + 3;
            }
            case 64: {
                return this.addAnnotationReferences(data, i + 1, 1);
            }
            case 91: {
                int numValues = this.u2(data, i + 1);
                int k = i + 3;
                for (int j = 0; j < numValues; ++j) {
                    k = this.addAnnotationElementValueReferences(data, k);
                }
                return k;
            }
        }
        throw new AnalyzerException("Unknown tag '" + tag + "'");
    }

    private int u2(byte[] data, int index) {
        return data[index] << 8 & 0xFF00 | data[index + 1] & 0xFF;
    }

    private void addImport(String type) {
        String name = this.getTypeName(type);
        if (name != null) {
            this.clazz.addImport(name, this.model);
        }
    }

    private String slashesToDots(String s) {
        return s.replace('/', '.');
    }

    private String getTypeName(String s) {
        String typed;
        if (s.length() > 0 && s.charAt(0) == '[') {
            String[] types = this.descriptorToTypes(s);
            if (types.length == 0) {
                return null;
            }
            typed = types[0];
        } else {
            typed = s;
        }
        return this.slashesToDots(typed);
    }

    private String descriptorToType(String descriptor) {
        if (!descriptor.startsWith("L")) {
            throw new AssertionError((Object)("Expected Object descriptor, but found '" + descriptor + "'"));
        }
        return descriptor.substring(1, descriptor.length() - 1);
    }

    private String[] descriptorToTypes(String descriptor) {
        int startIndex;
        int typesCount = 0;
        for (int i = 0; i < descriptor.length(); ++i) {
            if (descriptor.charAt(i) != ';') continue;
            ++typesCount;
        }
        String[] types = new String[typesCount];
        int typeIndex = 0;
        for (int index = 0; index < descriptor.length() && (startIndex = descriptor.indexOf(76, index)) >= 0; ++index) {
            index = descriptor.indexOf(59, startIndex + 1);
            types[typeIndex++] = descriptor.substring(startIndex + 1, index);
        }
        return types;
    }
}

