/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.model.CodePackage;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.model.UsingElement;
import guru.nidi.codeassert.util.CountSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodeClass
extends UsingElement<CodeClass> {
    private final String name;
    private final CodePackage pack;
    private final CountSet<CodePackage> usedPackages;
    private final CountSet<CodeClass> usedClasses;
    private final Set<CodeClass> annotations;
    final List<MemberInfo> fields = new ArrayList<MemberInfo>();
    final List<MemberInfo> methods = new ArrayList<MemberInfo>();
    String sourceFile;
    int codeSize;
    int totalSize;
    boolean concrete;
    int codeLines;
    int commentLines;
    int emptyLines;
    int totalLines;

    CodeClass(String name, CodePackage pack) {
        this.name = name;
        this.pack = pack;
        this.usedPackages = new CountSet();
        this.usedClasses = new CountSet();
        this.annotations = new HashSet<CodeClass>();
        this.sourceFile = "Unknown";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CodePackage getPackage() {
        return this.pack;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public Set<CodeClass> getAnnotations() {
        return this.annotations;
    }

    public List<MemberInfo> getFields() {
        return this.fields;
    }

    public List<MemberInfo> getMethods() {
        return this.methods;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public int getCodeLines() {
        return this.codeLines;
    }

    public int getCommentLines() {
        return this.commentLines;
    }

    public int getEmptyLines() {
        return this.emptyLines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    @Override
    public CodeClass self() {
        return this;
    }

    public Collection<CodePackage> usedForeignPackages() {
        HashSet<CodePackage> res = new HashSet<CodePackage>(this.usedPackages());
        res.remove(this.pack);
        return res;
    }

    public Collection<CodePackage> usedPackages() {
        return this.usedPackages.asSet();
    }

    public Map<CodePackage, Integer> usedPackageCounts() {
        return this.usedPackages.asMap();
    }

    public Collection<CodeClass> usedClasses() {
        return this.usedClasses.asSet();
    }

    public Map<CodeClass, Integer> usedClassCounts() {
        return this.usedClasses.asMap();
    }

    @Override
    public boolean uses(CodePackage pack) {
        return this.usedPackages.contains(pack);
    }

    @Override
    public Collection<CodeClass> uses() {
        return this.usedClasses();
    }

    @Override
    public String getPackageName() {
        return this.pack.getName();
    }

    @Override
    public Collection<String> usedVia(UsingElement<CodeClass> other) {
        return Collections.emptyList();
    }

    @Override
    public boolean isMatchedBy(LocationMatcher matcher) {
        return matcher.matchesClass(this.name);
    }

    void addImport(String type, Model model) {
        if (!this.name.equals(type)) {
            String packName = Model.packageOf(type);
            CodePackage p = model.getOrCreatePackage(packName);
            this.usedPackages.add(p);
            this.pack.addEfferent(p);
            this.usedClasses.add(model.getOrCreateClass(type));
        }
    }

    void addAnnotation(String type, Model model) {
        this.addImport(type, model);
        this.annotations.add(model.getOrCreateClass(type));
    }

    public boolean equals(Object other) {
        if (other instanceof CodeClass) {
            CodeClass otherClass = (CodeClass)other;
            return otherClass.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.name;
    }
}

