/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.jacoco;

import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.config.ValuedLocation;
import guru.nidi.codeassert.jacoco.Coverage;
import guru.nidi.codeassert.jacoco.CoverageCollector;
import guru.nidi.codeassert.jacoco.Coverages;
import guru.nidi.codeassert.jacoco.JacocoResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class JacocoAnalyzer
implements Analyzer<List<ValuedLocation>> {
    private final File jacocoCsv;
    private final CoverageCollector collector;

    public JacocoAnalyzer(CoverageCollector collector) {
        this(new File("target/site/jacoco/jacoco.csv"), collector);
    }

    public JacocoAnalyzer(File jacocoCsv, CoverageCollector collector) {
        this.jacocoCsv = jacocoCsv.isDirectory() ? new File(jacocoCsv, "jacoco.csv") : jacocoCsv;
        this.collector = collector;
        if (!this.jacocoCsv.exists()) {
            throw new AnalyzerException("Coverage information in '" + jacocoCsv + "' does not exist.");
        }
    }

    public JacocoResult analyze() {
        Coverages coverages = this.readReport();
        return this.filterResult(coverages);
    }

    private Coverages readReport() {
        Coverages coverages = new Coverages();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jacocoCsv), StandardCharsets.UTF_8));){
            String line;
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] parts = line.split(",");
                coverages.add(new Coverage(parts[1], parts[2], Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), Integer.parseInt(parts[5]), Integer.parseInt(parts[6]), Integer.parseInt(parts[7]), Integer.parseInt(parts[8]), Integer.parseInt(parts[9]), Integer.parseInt(parts[10]), Integer.parseInt(parts[11]), Integer.parseInt(parts[12])));
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            throw new AnalyzerException("Problem analyzing coverage", e);
        }
        return coverages;
    }

    private JacocoResult filterResult(Coverages coverages) {
        UsageCounter counter = new UsageCounter();
        List<ValuedLocation> locations = coverages.asStream().map(c -> c.toValuedLocation(this.collector.types)).filter(vl -> counter.accept(this.collector.accept((ValuedLocation)vl))).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new JacocoResult(this, locations, this.collector.unusedActions(counter), this.collector.types);
    }
}

