/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.findbugs;

import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.findbugs.BugCollector;
import guru.nidi.codeassert.findbugs.FindBugsResult;
import guru.nidi.codeassert.findbugs.PluginLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class FindBugsAnalyzer
implements Analyzer<List<BugInstance>> {
    private static final Comparator<BugInstance> BUG_COMPARATOR = Comparator.comparingInt(BugInstance::getPriority).thenComparingInt(BugInstance::getBugRank).thenComparing(BugInstance::getType);
    final AnalyzerConfig config;
    private final BugCollector collector;

    public FindBugsAnalyzer(AnalyzerConfig config, BugCollector collector) {
        this.config = config;
        this.collector = collector;
    }

    public FindBugsResult analyze() {
        Project project = this.createProject();
        BugCollectionBugReporter bugReporter = this.createReporter(project);
        FindBugs2 findBugs = this.createFindBugs(project, bugReporter);
        try {
            findBugs.execute();
        }
        catch (IOException | InterruptedException e) {
            throw new AnalyzerException("Problem executing FindBugs.", e);
        }
        return this.createBugList(bugReporter);
    }

    private Project createProject() {
        Project project = new Project();
        PluginLoader.addPluginsTo(project);
        for (AnalyzerConfig.Path clazz : this.config.getClassPaths(new Language[0])) {
            project.addFile(clazz.getPath());
        }
        project.addSourceDirs((Collection)this.config.getSourcePaths(new Language[0]).stream().map(AnalyzerConfig.Path::getPath).collect(Collectors.toList()));
        String pathSeparator = System.getProperty("path.separator");
        String classPath = System.getProperty("java.class.path");
        for (String entry : classPath.split(pathSeparator)) {
            project.addAuxClasspathEntry(entry);
        }
        return project;
    }

    private BugCollectionBugReporter createReporter(Project project) {
        BugCollectionBugReporter bugReporter = new BugCollectionBugReporter(project);
        bugReporter.setPriorityThreshold(3);
        bugReporter.setApplySuppressions(true);
        return bugReporter;
    }

    private FindBugs2 createFindBugs(Project project, BugCollectionBugReporter bugReporter) {
        FindBugs2 findBugs = new FindBugs2();
        findBugs.setProject(project);
        findBugs.setBugReporter((BugReporter)bugReporter);
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findBugs.setUserPreferences(UserPreferences.createDefaultUserPreferences());
        return findBugs;
    }

    private FindBugsResult createBugList(BugCollectionBugReporter bugReporter) {
        UsageCounter counter = new UsageCounter();
        List<BugInstance> bugs = bugReporter.getBugCollection().getCollection().stream().filter(b -> counter.accept(this.collector.accept((BugInstance)b))).sorted(BUG_COMPARATOR).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new FindBugsResult(this, bugs, this.collector.unusedActions(counter));
    }
}

