/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.dependency.DependencyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MatcherUtils {
    private MatcherUtils() {
    }

    public static String deps(String prefix, Map<String, DependencyMap.Info> deps) {
        StringBuilder s = new StringBuilder();
        for (String dep : MatcherUtils.sorted(deps.keySet())) {
            s.append(prefix).append(dep);
            Set<String> by = deps.get(dep).getVias();
            if (!by.isEmpty()) {
                s.append(" (by ").append(MatcherUtils.join(by)).append(')');
            }
            s.append('\n');
        }
        return s.toString();
    }

    public static String join(Collection<String> packs) {
        StringBuilder s = new StringBuilder();
        for (String pack : MatcherUtils.sorted(packs)) {
            s.append(", ").append(pack);
        }
        return s.length() > 0 ? s.substring(2) : s.toString();
    }

    public static List<String> sorted(Collection<String> ss) {
        ArrayList<String> sorted = new ArrayList<String>(ss);
        Collections.sort(sorted);
        return sorted;
    }

    public static List<String> sortedPatterns(Collection<LocationMatcher> patterns) {
        ArrayList<String> ss = new ArrayList<String>();
        for (LocationMatcher pattern : patterns) {
            ss.add(pattern.toString());
        }
        return MatcherUtils.sorted(ss);
    }
}

