/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.dependency.AmbiguousRuleException;
import guru.nidi.codeassert.dependency.CodeElement;
import guru.nidi.codeassert.dependency.Dependencies;
import guru.nidi.codeassert.dependency.DependencyRules;
import guru.nidi.codeassert.dependency.RuleAccessor;
import guru.nidi.codeassert.dependency.Usage;
import guru.nidi.codeassert.model.Scope;
import guru.nidi.codeassert.model.UsingElement;
import java.util.List;

public class DependencyRule
extends CodeElement {
    final Usage use = new Usage();
    final Usage usedBy = new Usage();
    boolean optional;

    DependencyRule(String pattern, boolean allowAll) {
        super(pattern, allowAll);
    }

    public static DependencyRule allowAll(String name) {
        return new DependencyRule(name, true);
    }

    public static DependencyRule denyAll(String name) {
        return new DependencyRule(name, false);
    }

    public DependencyRule mustUse(CodeElement ... rules) {
        this.use.must(rules);
        return this;
    }

    public DependencyRule mayUse(CodeElement ... rules) {
        this.use.may(rules);
        return this;
    }

    public DependencyRule mustNotUse(CodeElement ... rules) {
        this.use.mustNot(rules);
        return this;
    }

    public DependencyRule mustBeUsedBy(CodeElement ... rules) {
        this.usedBy.must(rules);
        return this;
    }

    public DependencyRule mayBeUsedBy(CodeElement ... rules) {
        this.usedBy.may(rules);
        return this;
    }

    public DependencyRule mustNotBeUsedBy(CodeElement ... rules) {
        this.usedBy.mustNot(rules);
        return this;
    }

    public DependencyRule optional() {
        this.optional = true;
        return this;
    }

    public boolean isEmpty() {
        return this.use.isEmpty() && this.usedBy.isEmpty();
    }

    public <T extends UsingElement<T>> Analyzer analyzer(Scope<T> scope, DependencyRules rules) {
        return new Analyzer<T>(scope, rules);
    }

    @Override
    public String toString() {
        return "DependencyRule for " + this.pattern + "\n  use:      " + this.use + "\n  used by:  " + this.usedBy + "\n";
    }

    public class Analyzer<T extends UsingElement<T>> {
        final Dependencies result = new Dependencies();
        private final Scope<T> scope;
        private final DependencyRules rules;
        private final List<T> elems;

        public Analyzer(Scope<T> scope, DependencyRules rules) {
            this.scope = scope;
            this.rules = rules;
            this.elems = scope.matchingElements(DependencyRule.this.pattern);
        }

        public Dependencies analyze() {
            this.analyzeNotExisting();
            this.analyzeMissing();
            this.analyzeAllowAndDeny();
            return this.result;
        }

        private void analyzeNotExisting() {
            if (!DependencyRule.this.optional && this.elems.isEmpty()) {
                this.result.notExisting.add(DependencyRule.this.pattern);
            }
        }

        private void analyzeMissing() {
            for (UsingElement elem : this.elems) {
                for (LocationMatcher mustMatcher : DependencyRule.this.use.must) {
                    for (UsingElement must : this.scope.matchingElements(mustMatcher)) {
                        if (elem.uses(must)) continue;
                        this.result.missing.with(DependencyRule.this.pattern.specificity(), elem, must);
                    }
                }
            }
        }

        private void analyzeAllowAndDeny() {
            for (UsingElement elem : this.elems) {
                for (UsingElement dep : elem.uses()) {
                    int denied;
                    int allowed = this.calcAllowedSpecificity(elem, dep);
                    if (this.isAmbiguous(allowed, denied = this.calcDeniedSpecificity(elem, dep))) {
                        throw new AmbiguousRuleException(DependencyRule.this, elem, dep);
                    }
                    if (this.isAllowed(allowed, denied)) {
                        this.result.allowed.with(DependencyRule.this.pattern.specificity(), elem, dep);
                    }
                    if (!this.isDenied(allowed, denied) || this.isAllowed(elem, dep)) continue;
                    int spec = denied == 0 ? 0 : DependencyRule.this.pattern.specificity();
                    this.result.denied.with(spec, elem, dep);
                }
            }
        }

        private boolean isAllowed(T elem, T dep) {
            return this.rules.allowIntraPackageDeps && ((UsingElement)elem).getPackageName().equals(((UsingElement)dep).getPackageName());
        }

        private boolean isAllowed(int allowed, int denied) {
            return allowed > denied || DependencyRule.this.allowAll && denied == 0;
        }

        private boolean isDenied(int allowed, int denied) {
            return denied > allowed || !DependencyRule.this.allowAll && allowed == 0;
        }

        private boolean isAmbiguous(int allowed, int denied) {
            return allowed != 0 && allowed == denied;
        }

        private int calcDeniedSpecificity(T thisPack, T dep) {
            return Math.max(((UsingElement)dep).mostSpecificMatch(DependencyRule.this.use.mustNot), this.rules.mostSpecificUsageMatch(thisPack, dep, RuleAccessor.MUST_NOT_BE_USED));
        }

        private int calcAllowedSpecificity(T thisPack, T dep) {
            int useAllowed = Math.max(((UsingElement)dep).mostSpecificMatch(DependencyRule.this.use.must), ((UsingElement)dep).mostSpecificMatch(DependencyRule.this.use.may));
            int usedByAllowed = Math.max(this.rules.mostSpecificUsageMatch(thisPack, dep, RuleAccessor.MUST_BE_USED), this.rules.mostSpecificUsageMatch(thisPack, dep, RuleAccessor.MAY_BE_USED));
            return Math.max(useAllowed, usedByAllowed);
        }
    }
}

