/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import java.util.Arrays;
import java.util.List;

public enum Language {
    JAVA("java", Arrays.asList(".java")),
    KOTLIN("kotlin", Arrays.asList(".kt", ".kts")),
    SCALA("scala", Arrays.asList(".scala")),
    GROOVY("groovy", Arrays.asList(".groovy", ".gvy", ".gy", ".gsh"));

    final String path;
    final List<String> suffices;

    private Language(String path, List<String> suffices) {
        this.path = path;
        this.suffices = suffices;
    }

    public static Language byFilename(String filename) {
        String suffix = filename.substring(filename.lastIndexOf(46));
        for (Language lang : Language.values()) {
            if (!lang.suffices.contains(suffix)) continue;
            return lang;
        }
        return null;
    }
}

