/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class In {
    private final List<Location> locs;

    private In(List<Location> locs) {
        this.locs = locs;
    }

    public static In locs(String ... locs) {
        ArrayList<Location> ls = new ArrayList<Location>();
        for (String loc : locs) {
            ls.add(Location.of(loc));
        }
        return new In(ls);
    }

    public static In loc(String loc) {
        return new In(Collections.singletonList(Location.of(loc)));
    }

    public static In everywhere() {
        return In.locs(new String[0]);
    }

    public static In languages(Language ... languages) {
        return In.everywhere().withLanguages(languages);
    }

    public static In packages(String ... packages) {
        return In.everywhere().withPackages(packages);
    }

    public static In classes(String ... classes) {
        return In.everywhere().withClasses(classes);
    }

    public static In classes(Class<?> ... classes) {
        ArrayList<Location> ls = new ArrayList<Location>();
        for (Class<?> loc : classes) {
            ls.add(Location.ofClass(loc));
        }
        return new In(ls);
    }

    public static In clazz(Class<?> clazz) {
        return In.loc(clazz.getName());
    }

    public static In methods(String ... methods) {
        return In.everywhere().withMethods(methods);
    }

    public In and(In in) {
        ArrayList<Location> res = new ArrayList<Location>(this.locs);
        res.addAll(in.locs);
        return new In(res);
    }

    public In withLanguages(Language ... languages) {
        ArrayList<Location> res = new ArrayList<Location>();
        for (Language language : languages) {
            for (Location loc : this.baseLocs()) {
                res.add(loc.andLanguage(language));
            }
        }
        return new In(res);
    }

    public In withPackages(String ... packages) {
        ArrayList<Location> res = new ArrayList<Location>();
        for (String pack : packages) {
            for (Location loc : this.baseLocs()) {
                res.add(loc.andPackage(pack));
            }
        }
        return new In(res);
    }

    public In withClasses(String ... classes) {
        ArrayList<Location> res = new ArrayList<Location>();
        for (String clazz : classes) {
            for (Location loc : this.baseLocs()) {
                res.add(loc.andClass(clazz));
            }
        }
        return new In(res);
    }

    public In withMethods(String ... methods) {
        ArrayList<Location> res = new ArrayList<Location>();
        for (String method : methods) {
            for (Location loc : this.baseLocs()) {
                res.add(loc.andMethod(method));
            }
        }
        return new In(res);
    }

    private List<Location> baseLocs() {
        if (this.locs.isEmpty()) {
            ArrayList<Location> res = new ArrayList<Location>(this.locs);
            res.add(Location.all());
            return res;
        }
        return this.locs;
    }

    public Ignore ignore(String ... names) {
        return new Ignore(this.locs, Arrays.asList(names));
    }

    public Ignore ignoreAll() {
        return this.ignore(new String[0]);
    }
}

