/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Action;
import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.util.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCollector<S, A extends Action, T extends BaseCollector<S, A, T>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCollector.class);

    @SafeVarargs
    public final T because(String reason, A ... actions) {
        return this.config(CollectorConfig.because((String)reason, actions));
    }

    @SafeVarargs
    public final T just(A ... actions) {
        return this.config(CollectorConfig.just(actions));
    }

    protected abstract T config(CollectorConfig<A> ... var1);

    public T apply(Iterable<CollectorConfig<A>> configs) {
        ArrayList<CollectorConfig<A>> cs = new ArrayList<CollectorConfig<A>>();
        for (CollectorConfig<A> config : configs) {
            cs.add(config);
        }
        return this.config(cs.toArray(new CollectorConfig[cs.size()]));
    }

    public abstract ActionResult accept(S var1);

    protected abstract ActionResult doAccept(S var1, A var2);

    protected abstract List<A> unused(UsageCounter var1);

    @SafeVarargs
    protected final ActionResult accept(S issue, T parent, CollectorConfig<A> ... configs) {
        ActionResult res = ActionResult.undecided(null);
        for (CollectorConfig<A> config : configs) {
            for (Action action : config.actions) {
                res = res.orMoreQuality(this.doAccept(issue, action));
            }
        }
        return res.orMoreQuality(((BaseCollector)parent).accept(issue));
    }

    @SafeVarargs
    protected final List<A> unused(UsageCounter counter, T parent, CollectorConfig<A> ... configs) {
        ArrayList<Action<Object>> res = new ArrayList<Action<Object>>();
        for (CollectorConfig<A> config : configs) {
            if (config.ignoreUnused) continue;
            for (Action action : config.actions) {
                if (counter.getCount(action) != 0) continue;
                res.add(action);
            }
        }
        res.addAll(((BaseCollector)parent).unused(counter));
        return res;
    }

    public List<String> unusedActions(UsageCounter counter) {
        ArrayList<String> res = new ArrayList<String>();
        for (Action unused : this.unused(counter)) {
            res.add(unused == null ? "    Base filtering" : unused.toString());
        }
        return res;
    }

    public void printUnusedWarning(UsageCounter counter) {
        String s = ListUtils.join("\n", this.unusedActions(counter));
        if (s.length() > 0) {
            int i;
            StackTraceElement[] trace = new Exception().fillInStackTrace().getStackTrace();
            for (i = 0; i < trace.length; ++i) {
                boolean testClass;
                String clazz = trace[i].getClassName();
                boolean projectClass = !clazz.startsWith("guru.nidi.codeassert") && !clazz.startsWith("org.hamcrest") && !clazz.startsWith("org.junit");
                boolean bl = testClass = clazz.endsWith("Test") || clazz.startsWith("Test");
                if (projectClass || testClass) break;
            }
            String location = i == trace.length ? "" : "In " + trace[i].getClassName() + "#" + trace[i].getMethodName() + ": ";
            LOG.warn(location + "These collector actions have not been used:\n" + s);
        }
    }

    protected List<A> unusedNullAction(UsageCounter counter, boolean hasDefaultConfig) {
        return counter.getCount(null) == 0 && hasDefaultConfig ? Collections.singletonList(null) : Collections.emptyList();
    }

    protected String guessClassFromFile(String filename, Language language) {
        int lang;
        String file = filename.replace('\\', '/');
        int slash = file.lastIndexOf(47);
        int dot = file.lastIndexOf(46);
        int src = file.indexOf("/src/") + 4;
        int later = Math.max(src, lang = file.indexOf("/" + language.path + "/") + language.path.length() + 1);
        int start = later >= 5 ? later + 1 : slash + 1;
        return file.substring(start, dot).replace('/', '.');
    }
}

