/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.checkstyle.CheckstyleResult;
import guru.nidi.codeassert.checkstyle.StyleChecks;
import guru.nidi.codeassert.checkstyle.StyleEventCollector;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckstyleAnalyzer
implements Analyzer<List<AuditEvent>> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckstyleAnalyzer.class);
    private final AnalyzerConfig config;
    private final StyleChecks checks;
    private final StyleEventCollector collector;
    private static final Comparator<AuditEvent> EVENT_COMPARATOR = Comparator.comparing(AuditEvent::getSeverityLevel).thenComparing(e -> e.getLocalizedMessage().getKey());

    public CheckstyleAnalyzer(AnalyzerConfig config, StyleChecks checks, StyleEventCollector collector) {
        this.config = config;
        this.checks = checks;
        this.collector = collector;
    }

    public CheckstyleResult analyze() {
        Checker checker = new Checker();
        try {
            LoggingAuditListener listener = new LoggingAuditListener();
            checker.addListener((AuditListener)listener);
            checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
            checker.configure(ConfigurationLoader.loadConfiguration((String)this.checks.location, (PropertyResolver)this.createPropertyResolver()));
            checker.process(this.config.getSources(new Language[0]));
            CheckstyleResult checkstyleResult = this.createResult(listener.events);
            return checkstyleResult;
        }
        catch (CheckstyleException e) {
            throw new AnalyzerException("Problem executing Checkstyle.", e);
        }
        finally {
            checker.destroy();
        }
    }

    private PropertyResolver createPropertyResolver() {
        Properties p = new Properties();
        for (Map.Entry<String, Object> param : this.checks.params.entrySet()) {
            p.setProperty(param.getKey(), this.propertyValue(param.getKey(), param.getValue()));
        }
        return new PropertiesExpander(p);
    }

    private String propertyValue(String name, Object value) {
        if (name.endsWith("-tokens")) {
            StringBuilder tokens = new StringBuilder();
            for (Integer val : (List)value) {
                for (Field f : TokenTypes.class.getFields()) {
                    try {
                        if (!val.equals(f.get(null))) continue;
                        tokens.append(tokens.length() == 0 ? "" : ",").append(f.getName());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            return tokens.toString();
        }
        return value.toString();
    }

    private CheckstyleResult createResult(List<AuditEvent> events) {
        UsageCounter counter = new UsageCounter();
        List<AuditEvent> res = events.stream().filter(e -> counter.accept(this.collector.accept((AuditEvent)e))).sorted(EVENT_COMPARATOR).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new CheckstyleResult(this, res, this.collector.unusedActions(counter));
    }

    private static class LoggingAuditListener
    implements AuditListener {
        final List<AuditEvent> events = new ArrayList<AuditEvent>();

        private LoggingAuditListener() {
        }

        public void auditStarted(AuditEvent event) {
        }

        public void auditFinished(AuditEvent event) {
        }

        public void fileStarted(AuditEvent event) {
        }

        public void fileFinished(AuditEvent event) {
        }

        public void addError(AuditEvent event) {
            this.events.add(event);
        }

        public void addException(AuditEvent event, Throwable throwable) {
            LOG.warn(event.getFileName() + ":" + event.getLine() + " " + event.getMessage(), throwable);
        }
    }
}

