/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.NullArgumentException;
import org.apache.geronimo.common.propertyeditor.ArrayPropertyEditorAdapter;
import org.apache.geronimo.common.propertyeditor.BooleanEditor;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.kernel.ClassLoading;

public class PropertyEditors {
    public static PropertyEditor findEditor(Class type) {
        Class<?> ctype;
        if (type == null) {
            throw new NullArgumentException("type");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null && type.isArray() && (editor = PropertyEditors.findEditor(ctype = type.getComponentType())) != null) {
            editor = new ArrayPropertyEditorAdapter(ctype, editor);
        }
        return editor;
    }

    public static PropertyEditor findEditor(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        Class type = null;
        try {
            type = ClassLoading.loadClass((String)typeName, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            type = ClassLoading.loadClass((String)(typeName + "$PropertyEditor"), (ClassLoader)classLoader);
        }
        return PropertyEditors.findEditor(type);
    }

    public static PropertyEditor getEditor(Class type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new PropertyEditorException("No property editor for type: " + type);
        }
        return editor;
    }

    public static void registerEditor(Class type, Class editorType) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        if (editorType == null) {
            throw new NullArgumentException("editorType");
        }
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (editorTypeName == null) {
            throw new NullArgumentException("editorTypeName");
        }
        Class type = ClassLoading.loadClass((String)typeName);
        Class editorType = ClassLoading.loadClass((String)editorTypeName);
        PropertyEditors.registerEditor(type, editorType);
    }

    public static List getEditorSearchPath() {
        String[] path = PropertyEditorManager.getEditorSearchPath();
        ArrayList<String> list = new ArrayList<String>(path.length);
        for (int i = 0; i < path.length; ++i) {
            list.add(path[i]);
        }
        return list;
    }

    public static void setEditorSearchPath(List path) {
        if (path == null) {
            throw new NullArgumentException("path");
        }
        String[] elements = path.toArray(new String[path.size()]);
        PropertyEditorManager.setEditorSearchPath(elements);
    }

    public static void appendEditorSearchPath(List names) {
        if (names == null) {
            throw new NullArgumentException("names");
        }
        if (names.size() == 0) {
            return;
        }
        List path = PropertyEditors.getEditorSearchPath();
        path.addAll(names);
        PropertyEditors.setEditorSearchPath(path);
    }

    public static void appendEditorSearchPath(String[] names) {
        if (names == null) {
            throw new NullArgumentException("names");
        }
        if (names.length == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.add(names[i]);
        }
        PropertyEditors.appendEditorSearchPath(list);
    }

    public static void appendEditorSearchPath(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        PropertyEditors.appendEditorSearchPath(new String[]{name});
    }

    static {
        PropertyEditors.appendEditorSearchPath("org.apache.geronimo.common.propertyeditor");
        PropertyEditorManager.registerEditor(Boolean.class, BooleanEditor.class);
    }
}

