/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.AMPValidatorManager;
import dev.amp.validator.Context;
import dev.amp.validator.ErrorCodeMetadata;
import dev.amp.validator.ExtensionsContext;
import dev.amp.validator.ParsedAttrSpecs;
import dev.amp.validator.ParsedDocSpec;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.TagSpecDispatch;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.exception.ValidatorException;
import dev.amp.validator.utils.AttributeSpecUtils;
import dev.amp.validator.utils.DispatchKeyUtils;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

public class ParsedValidatorRules {
    private AMPValidatorManager ampValidatorManager;
    private ValidatorProtos.HtmlFormat.Code htmlFormat;
    private Map<Integer, ParsedTagSpec> parsedTagSpecById;
    private Map<String, TagSpecDispatch> tagSpecByTagName;
    private List<Integer> mandatoryTagSpecs;
    private Map<String, Pattern> fullMatchRegexes;
    private Map<String, Pattern> fullMatchCaseiRegexes;
    private Map<String, Pattern> partialMatchCaseiRegexes;
    private Map<String, Integer> typeIdentifiers;
    private ParsedAttrSpecs parsedAttrSpecs;
    private Map<Object, Boolean> tagSpecIdsToTrack;
    private Map<ValidatorProtos.ValidationError.Code, ErrorCodeMetadata> errorCodes;
    private Map<String, Integer> tagSpecNameToSpecId = new HashMap<String, Integer>();
    private static final Pattern TRANSFORMED_VALUE_REGEX = Pattern.compile("^(bing|google|self);v=(\\d+)$");
    private static final int MIN_BYTES = -2;
    private List<ParsedDocCssSpec> parsedCss;
    private List<ParsedDocSpec> parsedDoc;
    private Map<String, List<Integer>> extTagSpecIdsByExtName;

    public ParsedValidatorRules(@Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull AMPValidatorManager ampValidatorManager) {
        ErrorCodeMetadata errorCodeMetadata;
        int i;
        this.ampValidatorManager = ampValidatorManager;
        this.htmlFormat = htmlFormat;
        this.parsedTagSpecById = new HashMap<Integer, ParsedTagSpec>();
        this.tagSpecByTagName = new HashMap<String, TagSpecDispatch>();
        this.extTagSpecIdsByExtName = new HashMap<String, List<Integer>>();
        this.mandatoryTagSpecs = new ArrayList<Integer>();
        this.fullMatchRegexes = new HashMap<String, Pattern>();
        this.fullMatchCaseiRegexes = new HashMap<String, Pattern>();
        this.partialMatchCaseiRegexes = new HashMap<String, Pattern>();
        this.typeIdentifiers = new HashMap<String, Integer>();
        this.typeIdentifiers.put("\u26a1", 0);
        this.typeIdentifiers.put("\u26a1\ufe0f", 0);
        this.typeIdentifiers.put("amp", 0);
        this.typeIdentifiers.put("\u26a14ads", 0);
        this.typeIdentifiers.put("\u26a1\ufe0f4ads", 0);
        this.typeIdentifiers.put("amp4ads", 0);
        this.typeIdentifiers.put("\u26a14email", 0);
        this.typeIdentifiers.put("\u26a1\ufe0f4email", 0);
        this.typeIdentifiers.put("amp4email", 0);
        this.typeIdentifiers.put("actions", 0);
        this.typeIdentifiers.put("transformed", 0);
        this.typeIdentifiers.put("data-ampdevmode", 0);
        this.expandExtensionSpec();
        this.parsedAttrSpecs = new ParsedAttrSpecs(ampValidatorManager);
        this.parsedCss = new ArrayList<ParsedDocCssSpec>();
        for (ValidatorProtos.DocCssSpec cssSpec : this.ampValidatorManager.getRules().getCssList()) {
            this.parsedCss.add(new ParsedDocCssSpec(cssSpec, this.ampValidatorManager.getRules().getDeclarationListList()));
        }
        this.parsedDoc = new ArrayList<ParsedDocSpec>();
        for (ValidatorProtos.DocSpec docSpec : this.ampValidatorManager.getRules().getDocList()) {
            this.parsedDoc.add(new ParsedDocSpec(docSpec));
        }
        this.tagSpecIdsToTrack = new HashMap<Object, Boolean>();
        int numTags = this.ampValidatorManager.getRules().getTagsList().size();
        for (int tagSpecId = 0; tagSpecId < numTags; ++tagSpecId) {
            List<Object> tagSpecList;
            ValidatorProtos.TagSpec tag = this.ampValidatorManager.getRules().getTags(tagSpecId);
            if (!this.isTagSpecCorrectHtmlFormat(tag)) continue;
            if (tag.hasSpecName()) {
                this.tagSpecNameToSpecId.put(tag.getSpecName(), tagSpecId);
            }
            if (tag.getAlsoRequiresTagWarningList().size() > 0) {
                this.tagSpecIdsToTrack.put(tagSpecId, true);
            }
            for (String otherTag : tag.getAlsoRequiresTagWarningList()) {
                this.tagSpecIdsToTrack.put(otherTag, true);
            }
            if (!tag.getTagName().equals("$REFERENCE_POINT")) {
                String dispatchKey;
                if (!this.tagSpecByTagName.containsKey(tag.getTagName())) {
                    this.tagSpecByTagName.put(tag.getTagName(), new TagSpecDispatch());
                }
                TagSpecDispatch tagnameDispatch = this.tagSpecByTagName.get(tag.getTagName());
                if (tag.hasExtensionSpec()) {
                    dispatchKey = DispatchKeyUtils.makeDispatchKey(ValidatorProtos.AttrSpec.DispatchKeyType.NAME_VALUE_DISPATCH, AttributeSpecUtils.getExtensionNameAttribute(tag.getExtensionSpec()), tag.getExtensionSpec().getName(), "");
                    tagnameDispatch.registerDispatchKey(dispatchKey, tagSpecId);
                } else {
                    dispatchKey = this.ampValidatorManager.getDispatchKeyByTagSpecId(tagSpecId);
                    if (dispatchKey == null) {
                        tagnameDispatch.registerTagSpec(tagSpecId);
                    } else {
                        tagnameDispatch.registerDispatchKey(dispatchKey, tagSpecId);
                    }
                }
            }
            if (tag.hasMandatory()) {
                this.mandatoryTagSpecs.add(tagSpecId);
            }
            if (!tag.hasExtensionSpec()) continue;
            if (this.extTagSpecIdsByExtName.containsKey(tag.getExtensionSpec().getName())) {
                tagSpecList = this.extTagSpecIdsByExtName.get(tag.getExtensionSpec().getName());
                tagSpecList.add(tagSpecId);
                continue;
            }
            tagSpecList = new ArrayList<Integer>();
            tagSpecList.add(tagSpecId);
            this.extTagSpecIdsByExtName.put(tag.getExtensionSpec().getName(), tagSpecList);
        }
        this.errorCodes = new HashMap<ValidatorProtos.ValidationError.Code, ErrorCodeMetadata>();
        for (i = 0; i < this.ampValidatorManager.getRules().getErrorFormatsList().size(); ++i) {
            ValidatorProtos.ErrorFormat errorFormat = this.ampValidatorManager.getRules().getErrorFormats(i);
            if (errorFormat == null) continue;
            errorCodeMetadata = new ErrorCodeMetadata();
            errorCodeMetadata.setFormat(errorFormat.getFormat());
            this.errorCodes.put(errorFormat.getCode(), errorCodeMetadata);
        }
        for (i = 0; i < this.ampValidatorManager.getRules().getErrorSpecificityList().size(); ++i) {
            ValidatorProtos.ErrorSpecificity errorSpecificity = this.ampValidatorManager.getRules().getErrorSpecificity(i);
            if (errorSpecificity == null || (errorCodeMetadata = this.errorCodes.get((Object)errorSpecificity.getCode())) == null) continue;
            errorCodeMetadata.setSpecificity(errorSpecificity.getSpecificity());
        }
    }

    public Pattern getFullMatchRegex(@Nonnull String regex) {
        String regexEscape = regex.replace("{", "\\{");
        for (String fullMatchRegex : this.fullMatchRegexes.keySet()) {
            if (!fullMatchRegex.equals(regex)) continue;
            return this.fullMatchRegexes.get(regexEscape);
        }
        String fullMatchRegex = "^(" + regexEscape + ")$";
        Pattern pattern = Pattern.compile(fullMatchRegex);
        this.fullMatchRegexes.put(regexEscape, pattern);
        return pattern;
    }

    public Pattern getFullMatchCaseiRegex(@Nonnull String caseiRegex) {
        String caseiRegexEscape = caseiRegex.replace("{", "\\{");
        for (String fullMatchRegex : this.fullMatchCaseiRegexes.keySet()) {
            if (!fullMatchRegex.equals(caseiRegexEscape)) continue;
            return this.fullMatchCaseiRegexes.get(caseiRegexEscape);
        }
        Pattern pattern = Pattern.compile("^(" + caseiRegexEscape + ")$");
        this.fullMatchCaseiRegexes.put(caseiRegexEscape, pattern);
        return pattern;
    }

    public Pattern getPartialMatchCaseiRegex(@Nonnull String caseiRegex) {
        String caseiRegexEscape = caseiRegex.replace("{", "\\{");
        for (String fullMatchRegex : this.partialMatchCaseiRegexes.keySet()) {
            if (!fullMatchRegex.equals(caseiRegexEscape)) continue;
            return this.partialMatchCaseiRegexes.get(caseiRegexEscape);
        }
        Pattern pattern = Pattern.compile(caseiRegexEscape);
        this.partialMatchCaseiRegexes.put(caseiRegexEscape, pattern);
        return pattern;
    }

    public String getReferencePointName(@Nonnull ValidatorProtos.ReferencePoint referencePoint) throws TagValidationException {
        int tagSpecId = this.ampValidatorManager.getTagSpecIdByReferencePointTagSpecName(referencePoint.getTagSpecName());
        ParsedTagSpec refPointSpec = this.getByTagSpecId(tagSpecId);
        return TagSpecUtils.getTagSpecName(refPointSpec.getSpec());
    }

    public ParsedTagSpec getByTagSpecId(String specName) throws TagValidationException {
        int tagSpecId = this.ampValidatorManager.getTagSpecIdByReferencePointTagSpecName(specName);
        return this.getByTagSpecId(tagSpecId);
    }

    public Integer getTagSpecIdBySpecName(@Nonnull String specName) {
        return this.tagSpecNameToSpecId.get(specName);
    }

    public ParsedTagSpec getByTagSpecId(int id) throws TagValidationException {
        ParsedTagSpec parsed = this.parsedTagSpecById.get(id);
        if (parsed != null) {
            return parsed;
        }
        ValidatorProtos.TagSpec tag = this.ampValidatorManager.getRules().getTags(id);
        if (tag == null) {
            throw new TagValidationException("TagSpec is null for tag spec id " + id);
        }
        parsed = new ParsedTagSpec(this.parsedAttrSpecs, TagSpecUtils.shouldRecordTagspecValidated(tag, id, this.tagSpecIdsToTrack), tag, id);
        this.parsedTagSpecById.put(id, parsed);
        return parsed;
    }

    public int getTagSpecIdByReferencePointTagSpecName(@Nonnull String tagName) throws TagValidationException {
        return this.ampValidatorManager.getTagSpecIdByReferencePointTagSpecName(tagName);
    }

    public boolean betterValidationResultThan(@Nonnull ValidatorProtos.ValidationResult.Builder resultA, @Nonnull ValidatorProtos.ValidationResult.Builder resultB) throws ValidatorException {
        if (resultA.getStatus() != resultB.getStatus()) {
            return this.betterValidationStatusThan(resultA.getStatus(), resultB.getStatus());
        }
        if (this.isErrorSubset(resultB.getErrorsList(), resultA.getErrorsList())) {
            return true;
        }
        if (this.isErrorSubset(resultA.getErrorsList(), resultB.getErrorsList())) {
            return false;
        }
        if (this.maxSpecificity(resultA.getErrorsList()) > this.maxSpecificity(resultB.getErrorsList())) {
            return true;
        }
        if (this.maxSpecificity(resultB.getErrorsList()) > this.maxSpecificity(resultA.getErrorsList())) {
            return false;
        }
        if (resultA.getErrorsCount() < resultB.getErrorsCount()) {
            return true;
        }
        if (resultB.getErrorsCount() < resultA.getErrorsCount()) {
            return false;
        }
        return false;
    }

    public boolean isTypeIdentifier(@Nonnull String maybeTypeIdentifier) {
        return this.typeIdentifiers.containsKey(maybeTypeIdentifier);
    }

    public void validateTypeIdentifiers(@Nonnull Attributes attrs, @Nonnull List<String> formatIdentifiers, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        boolean hasMandatoryTypeIdentifier = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (!this.isTypeIdentifier(attrs.getLocalName(i))) continue;
            if (formatIdentifiers.contains(attrs.getLocalName(i))) {
                String typeIdentifier = attrs.getLocalName(i).replace("\u26a1\ufe0f", "amp").replace("\u26a1", "amp");
                if (!validationResult.getTypeIdentifierList().contains((Object)typeIdentifier)) {
                    validationResult.addTypeIdentifier(typeIdentifier);
                    context.recordTypeIdentifier(typeIdentifier);
                }
                if (!(typeIdentifier.equals("actions") || typeIdentifier.equals("transformed") || typeIdentifier.equals("data-ampdevmode"))) {
                    hasMandatoryTypeIdentifier = true;
                }
                if (typeIdentifier.equals("transformed") && !attrs.getValue(i).equals("")) {
                    Matcher reResult = TRANSFORMED_VALUE_REGEX.matcher(attrs.getValue(i));
                    if (reResult.matches()) {
                        validationResult.setTransformerVersion(Integer.parseInt(reResult.group(2)));
                    } else {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(attrs.getLocalName(i));
                        params.add("html");
                        params.add(attrs.getValue(i));
                        context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", validationResult);
                    }
                }
                if (!typeIdentifier.equals("data-ampdevmode")) continue;
                context.addError(ValidatorProtos.ValidationError.Code.DEV_MODE_ONLY, context.getLineCol(), new ArrayList<String>(), "", validationResult);
                continue;
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrs.getLocalName(i));
            params.add("html");
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_ATTR, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", validationResult);
        }
        if (!hasMandatoryTypeIdentifier) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(formatIdentifiers.get(0));
            params.add("html");
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ATTR_MISSING, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", validationResult);
        }
    }

    public void validateHtmlTag(@Nonnull ParsedHtmlTag htmlTag, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        switch (this.htmlFormat) {
            case AMP: {
                this.validateTypeIdentifiers(htmlTag.attrs(), TagSpecUtils.AMP_IDENTIFIERS, context, validationResult);
                break;
            }
            case AMP4ADS: {
                this.validateTypeIdentifiers(htmlTag.attrs(), TagSpecUtils.AMP4ADS_IDENTIFIERS, context, validationResult);
                break;
            }
            case AMP4EMAIL: {
                this.validateTypeIdentifiers(htmlTag.attrs(), TagSpecUtils.AMP4EMAIL_IDENTIFIERS, context, validationResult);
                break;
            }
        }
    }

    public int specificity(@Nonnull ValidatorProtos.ValidationError.Code errorCode) {
        return this.errorCodes.get((Object)errorCode).getSpecificity();
    }

    public int maxSpecificity(@Nonnull List<ValidatorProtos.ValidationError> errors) throws ValidatorException {
        int max = 0;
        for (ValidatorProtos.ValidationError error : errors) {
            if (error.getCode() == null) {
                throw new ValidatorException("Validation error code is null");
            }
            max = Math.max(this.specificity(error.getCode()), max);
        }
        return max;
    }

    public boolean isErrorSubset(@Nonnull List<ValidatorProtos.ValidationError> errorsA, @Nonnull List<ValidatorProtos.ValidationError> errorsB) {
        HashMap<ValidatorProtos.ValidationError.Code, Integer> codesA = new HashMap<ValidatorProtos.ValidationError.Code, Integer>();
        for (ValidatorProtos.ValidationError error : errorsA) {
            codesA.put(error.getCode(), 1);
        }
        HashMap<ValidatorProtos.ValidationError.Code, Integer> codesB = new HashMap<ValidatorProtos.ValidationError.Code, Integer>();
        for (ValidatorProtos.ValidationError error : errorsB) {
            codesB.put(error.getCode(), 1);
            if (codesA.containsKey((Object)error.getCode())) continue;
            return false;
        }
        return codesA.size() > codesB.size();
    }

    public boolean betterValidationStatusThan(@Nonnull ValidatorProtos.ValidationResult.Status statusA, @Nonnull ValidatorProtos.ValidationResult.Status statusB) throws ValidatorException {
        if (statusA == statusB) {
            return false;
        }
        if (statusA == ValidatorProtos.ValidationResult.Status.PASS) {
            return true;
        }
        if (statusB == ValidatorProtos.ValidationResult.Status.PASS) {
            return false;
        }
        if (statusA == ValidatorProtos.ValidationResult.Status.FAIL) {
            return true;
        }
        if (statusA == ValidatorProtos.ValidationResult.Status.UNKNOWN) {
            throw new ValidatorException("Status unknown");
        }
        return false;
    }

    public TagSpecDispatch dispatchForTagName(@Nonnull String tagName) {
        return this.tagSpecByTagName.get(tagName);
    }

    public String getStylesSpecUrl() {
        return this.ampValidatorManager.getRules().getStylesSpecUrl();
    }

    public String getTemplateSpecUrl() {
        return this.ampValidatorManager.getRules().getTemplateSpecUrl();
    }

    public String getScriptSpecUrl() {
        return this.ampValidatorManager.getRules().getScriptSpecUrl();
    }

    public List<ParsedDocCssSpec> getCss() {
        return this.parsedCss;
    }

    public List<ValidatorProtos.DescendantTagList> getDescendantTagLists() {
        return this.ampValidatorManager.getDescendantTagLists();
    }

    public String getCombinedDisallowedCdataRegex(int tagSpecId) {
        return this.ampValidatorManager.getCombinedDisallowedCdataRegex(tagSpecId);
    }

    public void maybeEmitGlobalTagValidationErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        this.maybeEmitMandatoryTagValidationErrors(context, validationResult);
        this.maybeEmitRequiresOrExcludesValidationErrors(context, validationResult);
        this.maybeEmitMandatoryAlternativesSatisfiedErrors(context, validationResult);
        this.maybeEmitDocSizeErrors(context, validationResult);
        this.maybeEmitCssLengthSpecErrors(context, validationResult);
        this.maybeEmitValueSetMismatchErrors(context, validationResult);
    }

    public void maybeEmitValueSetMismatchErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        Set<String> providedKeys = context.valueSetsProvided();
        for (String requiredKey : context.valueSetsRequired().keySet()) {
            if (providedKeys.contains(requiredKey)) continue;
            context.valueSetsRequired().get(requiredKey);
            for (ValidatorProtos.ValidationError error : context.valueSetsRequired().get(requiredKey)) {
                context.addBuiltError(error, validationResult);
            }
        }
    }

    public void maybeEmitCssLengthSpecErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        ValidatorProtos.DocCssSpec cssSpec;
        if (context.getInlineStyleByteSize() == 0) {
            return;
        }
        int bytesUsed = context.getInlineStyleByteSize() + context.getStyleTagByteSize();
        ParsedDocCssSpec parsedCssSpec = context.matchingDocCssSpec();
        if (parsedCssSpec != null && (cssSpec = parsedCssSpec.getSpec()).getMaxBytes() != -2 && bytesUsed > cssSpec.getMaxBytes()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(String.valueOf(bytesUsed));
            params.add(String.valueOf(cssSpec.getMaxBytes()));
            if (cssSpec.hasMaxBytesIsWarning()) {
                context.addWarning(ValidatorProtos.ValidationError.Code.STYLESHEET_AND_INLINE_STYLE_TOO_LONG, context.getLineCol(), params, cssSpec.getMaxBytesSpecUrl(), validationResult);
            } else {
                context.addError(ValidatorProtos.ValidationError.Code.STYLESHEET_AND_INLINE_STYLE_TOO_LONG, context.getLineCol(), params, cssSpec.getMaxBytesSpecUrl(), validationResult);
            }
        }
    }

    public void maybeEmitMandatoryAlternativesSatisfiedErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        List<String> satisfied = context.getMandatoryAlternativesSatisfied();
        ArrayList<String> missing = new ArrayList<String>();
        HashMap<String, String> specUrlsByMissing = new HashMap<String, String>();
        for (ValidatorProtos.TagSpec tagSpec : this.ampValidatorManager.getRules().getTagsList()) {
            String alternative;
            if (!tagSpec.hasMandatoryAlternatives() || !this.isTagSpecCorrectHtmlFormat(tagSpec) || satisfied.indexOf(alternative = tagSpec.getMandatoryAlternatives()) != -1 || missing.contains(alternative)) continue;
            missing.add(alternative);
            specUrlsByMissing.put(alternative, TagSpecUtils.getTagSpecUrl(tagSpec));
        }
        for (String tagMissing : missing) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(tagMissing);
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_TAG_MISSING, context.getLineCol(), params, (String)specUrlsByMissing.get(tagMissing), validationResult);
        }
    }

    public void maybeEmitMandatoryTagValidationErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        for (int tagSpecId : this.mandatoryTagSpecs) {
            ParsedTagSpec parsedTagSpec = this.getByTagSpecId(tagSpecId);
            if (!parsedTagSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers()) || context.getTagspecsValidated().containsKey(tagSpecId)) continue;
            ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(spec));
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_TAG_MISSING, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
        }
    }

    public void maybeEmitRequiresOrExcludesValidationErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        for (int tagSpecId : context.getTagspecsValidated().keySet()) {
            ArrayList<String> params;
            ParsedTagSpec parsedTagSpec = this.getByTagSpecId(tagSpecId);
            if (!parsedTagSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers())) continue;
            for (String condition : parsedTagSpec.requires()) {
                if (context.satisfiesCondition(condition)) continue;
                params = new ArrayList<String>();
                params.add(condition);
                params.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
                context.addError(ValidatorProtos.ValidationError.Code.TAG_REQUIRED_BY_MISSING, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
            }
            for (String condition : parsedTagSpec.excludes()) {
                if (!context.satisfiesCondition(condition)) continue;
                params = new ArrayList();
                params.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
                params.add(condition);
                context.addError(ValidatorProtos.ValidationError.Code.TAG_EXCLUDED_BY_TAG, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
            }
            for (String requiresTagWarning : parsedTagSpec.getAlsoRequiresTagWarning()) {
                ParsedTagSpec alsoRequiresTagspec;
                Integer tagSpecIdObj = this.getTagSpecIdBySpecName(requiresTagWarning);
                if (tagSpecIdObj != null && context.getTagspecsValidated().containsKey(tagSpecIdObj) || (alsoRequiresTagspec = this.getByTagSpecId(tagSpecIdObj)).getSpec().hasExtensionSpec() && alsoRequiresTagspec.getSpec().getSpecName().endsWith("extension script") && this.hasValidatedAlternativeTagSpec(context, alsoRequiresTagspec.getSpec().getExtensionSpec().getName())) continue;
                ArrayList<String> params2 = new ArrayList<String>();
                params2.add(TagSpecUtils.getTagSpecName(alsoRequiresTagspec.getSpec()));
                params2.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
                context.addWarning(ValidatorProtos.ValidationError.Code.WARNING_TAG_REQUIRED_BY_MISSING, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
            }
        }
        ExtensionsContext extensionsCtx = context.getExtensions();
        List<String> unusedRequired = extensionsCtx.unusedExtensionsRequired();
        for (String unusedExtensionName : unusedRequired) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(unusedExtensionName);
            context.addError(ValidatorProtos.ValidationError.Code.EXTENSION_UNUSED, context.getLineCol(), params, "", validationResult);
        }
    }

    public void maybeEmitDocSizeErrors(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        ParsedDocSpec parsedDocSpec = context.matchingDocSpec();
        if (parsedDocSpec != null) {
            int bytesUsed = context.getDocByteSize();
            ValidatorProtos.DocSpec docSpec = parsedDocSpec.spec();
            if (docSpec.getMaxBytes() != -2 && bytesUsed > docSpec.getMaxBytes()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(String.valueOf(docSpec.getMaxBytes()));
                params.add(String.valueOf(bytesUsed));
                context.addError(ValidatorProtos.ValidationError.Code.DOCUMENT_SIZE_LIMIT_EXCEEDED, context.getLineCol(), params, docSpec.getMaxBytesSpecUrl(), validationResult);
            }
        }
    }

    public boolean isDocSpecCorrectHtmlFormat(@Nonnull ValidatorProtos.DocSpec docSpec) {
        for (ValidatorProtos.HtmlFormat.Code htmlFormatCode : docSpec.getHtmlFormatList()) {
            if (htmlFormatCode != this.htmlFormat) continue;
            return true;
        }
        return false;
    }

    public boolean isDocCssSpecCorrectHtmlFormat(@Nonnull ValidatorProtos.DocCssSpec docCssSpec) {
        for (ValidatorProtos.HtmlFormat.Code htmlFormatCode : docCssSpec.getHtmlFormatList()) {
            if (htmlFormatCode != this.htmlFormat) continue;
            return true;
        }
        return false;
    }

    private boolean isTagSpecCorrectHtmlFormat(@Nonnull ValidatorProtos.TagSpec tagSpec) {
        for (ValidatorProtos.HtmlFormat.Code htmlFormatCode : tagSpec.getHtmlFormatList()) {
            if (htmlFormatCode != this.htmlFormat) continue;
            return true;
        }
        return false;
    }

    private void expandExtensionSpec() {
        int numTags = this.ampValidatorManager.getRules().getTagsList().size();
        for (int tagSpecId = 0; tagSpecId < numTags; ++tagSpecId) {
            ValidatorProtos.TagSpec tagSpec = this.ampValidatorManager.getRules().getTags(tagSpecId);
            if (!tagSpec.hasExtensionSpec()) continue;
            ValidatorProtos.TagSpec.Builder tagSpecBuilder = ValidatorProtos.TagSpec.newBuilder();
            tagSpecBuilder.mergeFrom(tagSpec);
            if (!tagSpec.hasSpecName()) {
                tagSpecBuilder.setSpecName(tagSpec.getTagName() + " extension .js script");
            }
            tagSpecBuilder.setMandatoryParent("HEAD");
            if (tagSpec.getExtensionSpec().hasDeprecatedAllowDuplicates()) {
                tagSpecBuilder.setUniqueWarning(true);
            } else {
                tagSpecBuilder.setUnique(true);
            }
            ValidatorProtos.CdataSpec cdataSpec = ValidatorProtos.CdataSpec.getDefaultInstance();
            cdataSpec = cdataSpec.toBuilder().setWhitespaceOnly(true).build();
            tagSpecBuilder.setCdata(cdataSpec);
            this.ampValidatorManager.getRules().setTags(tagSpecId, tagSpecBuilder.build());
        }
    }

    private boolean hasValidatedAlternativeTagSpec(@Nonnull Context context, String extName) {
        if (extName == null) {
            return false;
        }
        for (Integer alternativeTagSpecId : this.extTagSpecIdsByExtName.get(extName)) {
            if (!context.getTagspecsValidated().containsKey(alternativeTagSpecId)) continue;
            return true;
        }
        return false;
    }

    public List<ParsedDocSpec> getDoc() {
        return this.parsedDoc;
    }

    public ParsedAttrSpecs getParsedAttrSpecs() {
        return this.parsedAttrSpecs;
    }
}

