/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.Context;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ValidatorProtos;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class ExtensionsUtils {
    private ExtensionsUtils() {
    }

    public static boolean isExtensionScript(ParsedHtmlTag tag) {
        return !ExtensionsUtils.extensionScriptNameAttribute(tag).equals("");
    }

    public static boolean isAmpRuntimeScript(ParsedHtmlTag tag) {
        String src = tag.attrsByKey().get("src") != null ? tag.attrsByKey().get("src") : "";
        return ExtensionsUtils.isAsyncScriptTag(tag) && !ExtensionsUtils.isExtensionScript(tag) && src.startsWith("https://cdn.ampproject.org/") && src.endsWith("/v0.js");
    }

    public static boolean isAsyncScriptTag(ParsedHtmlTag tag) {
        return tag.upperName().equals("SCRIPT") && tag.attrsByKey().containsKey("async") && tag.attrsByKey().containsKey("src");
    }

    public static boolean isLtsScriptUrl(@Nonnull String url) {
        return url.startsWith("https://cdn.ampproject.org/lts/");
    }

    public static String extensionScriptNameAttribute(@Nonnull ParsedHtmlTag tag) {
        if (tag.upperName().equals("SCRIPT")) {
            String[] myStringArray;
            for (String attribute : myStringArray = new String[]{"custom-element", "custom-template", "host-service"}) {
                if (!tag.attrsByKey().containsKey(attribute)) continue;
                return attribute;
            }
        }
        return "";
    }

    public static String extensionScriptName(ParsedHtmlTag tag) {
        String nameAttr = ExtensionsUtils.extensionScriptNameAttribute(tag);
        if (nameAttr != null) {
            return tag.attrsByKey().get(nameAttr) != null ? tag.attrsByKey().get(nameAttr) : "";
        }
        return "";
    }

    public static void validateScriptSrcAttr(@Nonnull String srcAttr, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ScriptReleaseVersion scriptReleaseVersion;
        if (context.getScriptReleaseVersion() == ScriptReleaseVersion.UNKNOWN) {
            return;
        }
        ScriptReleaseVersion scriptReleaseVersion2 = scriptReleaseVersion = ExtensionsUtils.isLtsScriptUrl(srcAttr) ? ScriptReleaseVersion.LTS : ScriptReleaseVersion.STANDARD;
        if (context.getScriptReleaseVersion() != scriptReleaseVersion) {
            ArrayList<String> params = new ArrayList<String>();
            String specName = tagSpec.hasExtensionSpec() ? tagSpec.getExtensionSpec().getName() : tagSpec.getSpecName();
            params.add(specName);
            context.addError(scriptReleaseVersion == ScriptReleaseVersion.LTS ? ValidatorProtos.ValidationError.Code.LTS_SCRIPT_AFTER_NON_LTS : ValidatorProtos.ValidationError.Code.NON_LTS_SCRIPT_AFTER_LTS, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", result);
        }
    }

    public static enum ScriptReleaseVersion {
        UNKNOWN,
        STANDARD,
        LTS;

    }
}

