/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ParsedUrlSpec;
import dev.amp.validator.ParsedValueProperties;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.AttributeSpecUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ParsedAttrSpec {
    private ValidatorProtos.AttrSpec spec;
    private String attrName;
    private ParsedUrlSpec valueUrlSpec;
    private ParsedValueProperties valueProperties;
    private Map<String, ValidatorProtos.CssDeclaration> cssDeclarationByName;

    public ParsedAttrSpec(@Nonnull ValidatorProtos.AttrSpec attrSpec, String attrName) {
        this.spec = attrSpec;
        this.attrName = attrName;
        this.valueUrlSpec = null;
        this.valueProperties = null;
        this.cssDeclarationByName = new HashMap<String, ValidatorProtos.CssDeclaration>();
        for (ValidatorProtos.CssDeclaration cssDeclaration : attrSpec.getCssDeclarationList()) {
            if (cssDeclaration.getName() == null) continue;
            this.cssDeclarationByName.put(cssDeclaration.getName(), cssDeclaration);
        }
    }

    public String getAttrName() {
        return this.attrName;
    }

    public ValidatorProtos.AttrSpec getSpec() {
        return this.spec;
    }

    public ParsedUrlSpec getValueUrlSpec() {
        if (this.valueUrlSpec == null) {
            this.valueUrlSpec = new ParsedUrlSpec(this.spec.getValueUrl());
        }
        return this.valueUrlSpec;
    }

    public ParsedValueProperties getValuePropertiesOrNull() {
        if (!this.spec.hasValueProperties()) {
            return null;
        }
        if (this.valueProperties == null) {
            this.valueProperties = new ParsedValueProperties(this.spec.getValueProperties());
        }
        return this.valueProperties;
    }

    public Map<String, ValidatorProtos.CssDeclaration> getCssDeclarationByName() {
        return this.cssDeclarationByName;
    }

    public boolean isUsedForTypeIdentifiers(@Nonnull List<String> typeIdentifiers) {
        return AttributeSpecUtils.isUsedForTypeIdentifiers(typeIdentifiers, (List<String>)this.spec.getEnabledByList(), (List<String>)this.spec.getDisabledByList());
    }

    public void cleanup() {
        this.spec = null;
        this.attrName = null;
        this.valueUrlSpec = null;
        this.valueProperties = null;
        this.cssDeclarationByName = null;
    }
}

