/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.amp.validator.AMPValidatorManager;
import dev.amp.validator.CdataMatcher;
import dev.amp.validator.Context;
import dev.amp.validator.ExitCondition;
import dev.amp.validator.ExtensionsContext;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedValidatorRules;
import dev.amp.validator.ReferencePointMatcher;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.exception.ExitOnFirstErrorException;
import dev.amp.validator.exception.MaxParseNodesException;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.exception.ValidatorException;
import dev.amp.validator.utils.TagSpecUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AMPHtmlHandler
extends DefaultHandler {
    @Nonnull
    private final AMPValidatorManager validatorManager;
    @Nonnull
    private final ExitCondition exitCondition;
    private int maxNodesAllowed;
    private int totalNodes;
    @Nonnull
    private ValidatorProtos.ValidationResult.Builder validationResult;
    @Nonnull
    private final ValidatorProtos.HtmlFormat.Code htmlFormat;
    @Nonnull
    private final Context context;
    private ParsedHtmlTag encounteredTag;
    private StringBuilder charactersBuilder;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public AMPHtmlHandler(@Nonnull AMPValidatorManager validatorManager, @Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull ExitCondition condition, int maxNodesAllowed) {
        this.validatorManager = validatorManager;
        this.exitCondition = condition;
        this.maxNodesAllowed = maxNodesAllowed;
        this.htmlFormat = htmlFormat;
        this.validationResult = ValidatorProtos.ValidationResult.newBuilder();
        this.context = new Context(new ParsedValidatorRules(htmlFormat, validatorManager));
    }

    @Override
    public void startDocument() throws SAXException {
        this.validationResult.setStatus(ValidatorProtos.ValidationResult.Status.UNKNOWN);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.context.getRules().maybeEmitGlobalTagValidationErrors(this.context, this.validationResult);
            if (this.validationResult.getStatus() == ValidatorProtos.ValidationResult.Status.UNKNOWN) {
                this.validationResult.setStatus(ValidatorProtos.ValidationResult.Status.PASS);
            }
            if (this.validationResult.getErrorsCount() > 0) {
                this.validationResult.setStatus(ValidatorProtos.ValidationResult.Status.FAIL);
            }
        }
        catch (TagValidationException tagValidationException) {
            // empty catch block
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String maybeDuplicateAttrName;
        if (this.maxNodesAllowed > 0 && this.totalNodes > this.maxNodesAllowed) {
            throw new MaxParseNodesException();
        }
        ++this.totalNodes;
        this.encounteredTag = new ParsedHtmlTag(localName, attributes);
        if (this.encounteredTag.upperName().equals("HTML")) {
            this.context.getRules().validateHtmlTag(this.encounteredTag, this.context, this.validationResult);
        }
        if ((maybeDuplicateAttrName = this.encounteredTag.hasDuplicateAttrs()) != null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.encounteredTag.lowerName());
            params.add(maybeDuplicateAttrName);
            this.context.addWarning(ValidatorProtos.ValidationError.Code.DUPLICATE_ATTRIBUTE, this.context.getLineCol(), params, "", this.validationResult);
        }
        if (this.encounteredTag.upperName().equals("BODY")) {
            this.emitMissingExtensionErrors();
        }
        try {
            ValidateTagResult resultForReferencePoint = new ValidateTagResult(ValidatorProtos.ValidationResult.newBuilder(), null);
            resultForReferencePoint.getValidationResult().setStatus(ValidatorProtos.ValidationResult.Status.UNKNOWN);
            ReferencePointMatcher referencePointMatcher = this.context.getTagStack().parentReferencePointMatcher();
            if (referencePointMatcher != null) {
                resultForReferencePoint = referencePointMatcher.validateTag(this.encounteredTag, this.context);
            }
            ValidateTagResult resultForTag = TagSpecUtils.validateTag(this.context, this.encounteredTag, resultForReferencePoint.getBestMatchTagSpec());
            if (referencePointMatcher != null && resultForTag.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
                this.validationResult.mergeFrom(resultForReferencePoint.getValidationResult().build());
            }
            this.checkForReferencePointCollision(resultForReferencePoint.getBestMatchTagSpec(), resultForTag.getBestMatchTagSpec(), resultForTag.getValidationResult());
            this.validationResult.mergeFrom(resultForTag.getValidationResult().build());
            this.context.updateFromTagResults(this.encounteredTag, resultForReferencePoint, resultForTag);
            if (this.validationResult.getErrorsCount() > 0 && this.exitCondition == ExitCondition.EXIT_ON_FIRST_ERROR) {
                throw new ExitOnFirstErrorException();
            }
        }
        catch (CssValidationException | TagValidationException | ValidatorException | IOException exception) {
            // empty catch block
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.encounteredTag != null) {
            try {
                if (this.charactersBuilder != null) {
                    this.cdata(this.charactersBuilder.toString());
                } else {
                    this.cdata("");
                }
            }
            catch (CssValidationException | TagValidationException | IOException exception) {
                // empty catch block
            }
            this.encounteredTag.cleanup();
        }
        try {
            this.context.getTagStack().exitTag(this.context, this.validationResult);
        }
        catch (TagValidationException tagValidationException) {
            // empty catch block
        }
        this.charactersBuilder = null;
        this.encounteredTag = null;
    }

    @Override
    public void setDocumentLocator(@Nonnull Locator locator) {
        this.context.setLineCol(locator);
    }

    public ValidatorProtos.ValidationResult.Builder validationResult() {
        return this.validationResult;
    }

    public void emitMissingExtensionErrors() {
        ExtensionsContext extensionsCtx = this.context.getExtensions();
        for (ValidatorProtos.ValidationError error : extensionsCtx.missingExtensionErrors()) {
            this.context.addBuiltError(error, this.validationResult);
        }
    }

    private void checkForReferencePointCollision(ParsedTagSpec refPointSpec, ParsedTagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        if (refPointSpec == null || !refPointSpec.hasReferencePoints()) {
            return;
        }
        if (tagSpec == null || !tagSpec.hasReferencePoints()) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(tagSpec.getSpec()));
        params.add(refPointSpec.getReferencePoints().parentTagSpecName());
        this.context.addError(ValidatorProtos.ValidationError.Code.TAG_REFERENCE_POINT_CONFLICT, this.context.getLineCol(), params, refPointSpec.getReferencePoints().parentSpecUrl(), validationResult);
    }

    public void cdata(@Nonnull String text) throws TagValidationException, CssValidationException, IOException {
        CdataMatcher matcher;
        if (!this.context.getTagStack().hasAncestor("TEMPLATE") && this.context.getTagStack().isScriptTypeJsonChild()) {
            try {
                OBJECT_MAPPER.readTree(text);
            }
            catch (JsonProcessingException e) {
                ArrayList<String> params = new ArrayList<String>();
                this.context.addWarning(ValidatorProtos.ValidationError.Code.INVALID_JSON_CDATA, this.context.getLineCol(), params, "", this.validationResult);
            }
        }
        if ((matcher = this.context.getTagStack().cdataMatcher()) != null) {
            matcher.match(text, this.context, this.validationResult);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.encounteredTag != null) {
            if (this.charactersBuilder == null) {
                this.charactersBuilder = new StringBuilder();
            }
            this.charactersBuilder.append(new String(ch, start, length));
        }
    }
}

