/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.Context;
import dev.amp.validator.CssLength;
import dev.amp.validator.DescendantConstraints;
import dev.amp.validator.ExtensionsContext;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.RecordValidated;
import dev.amp.validator.TagSpecDispatch;
import dev.amp.validator.TagStack;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.exception.ValidatorException;
import dev.amp.validator.utils.AttributeSpecUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class TagSpecUtils {
    public static final List AMP_IDENTIFIERS = Arrays.asList("\u26a1", "\u26a1\ufe0f", "amp", "transformed", "data-ampdevmode");
    public static final List AMP4ADS_IDENTIFIERS = Arrays.asList("\u26a14ads", "\u26a1\ufe0f4ads", "amp4ads", "data-ampdevmode");
    public static final List AMP4EMAIL_IDENTIFIERS = Arrays.asList("\u26a14email", "\u26a1\ufe0f4email", "amp4email", "data-ampdevmode", "data-css-strict");
    public static final List ACTIONS_IDENTIFIERS = Arrays.asList("\u26a1", "\u26a1\ufe0f", "amp", "actions", "data-ampdevmode");

    private TagSpecUtils() {
    }

    public static String getTagSpecUrl(@Nonnull ValidatorProtos.TagSpec tagSpec) {
        if (tagSpec.hasSpecUrl()) {
            return tagSpec.getSpecUrl();
        }
        String extensionSpecUrlPrefix = "https://amp.dev/documentation/components/";
        if (tagSpec.hasExtensionSpec() && tagSpec.getExtensionSpec().getName() != null) {
            return "https://amp.dev/documentation/components/" + tagSpec.getExtensionSpec().getName();
        }
        if (tagSpec.getRequiresExtensionCount() > 0) {
            return "https://amp.dev/documentation/components/" + tagSpec.getRequiresExtension(0);
        }
        return "";
    }

    public static String getTagSpecName(@Nonnull ValidatorProtos.TagSpec tagSpec) {
        return tagSpec.hasSpecName() ? tagSpec.getSpecName() : tagSpec.getTagName().toLowerCase();
    }

    public static String getTagDescriptiveName(@Nonnull ValidatorProtos.TagSpec tagSpec) {
        return tagSpec.hasDescriptiveName() ? tagSpec.getDescriptiveName() : tagSpec.getTagName().toLowerCase();
    }

    public static RecordValidated shouldRecordTagspecValidated(@Nonnull ValidatorProtos.TagSpec tag, int tagSpecId, @Nonnull Map<Object, Boolean> tagSpecIdsToTrack) {
        if (tag.hasMandatory() || tagSpecIdsToTrack.containsKey(tagSpecId)) {
            return RecordValidated.ALWAYS;
        }
        if (tag.hasUnique() || tag.getRequiresList().size() > 0 || tag.hasUniqueWarning()) {
            return RecordValidated.IF_PASSING;
        }
        return RecordValidated.NEVER;
    }

    public static ValidateTagResult validateTag(@Nonnull Context context, @Nonnull ParsedHtmlTag encounteredTag, ParsedTagSpec bestMatchReferencePoint) throws TagValidationException, ValidatorException, IOException, CssValidationException {
        ValidatorProtos.ValidationResult.Builder result;
        TagSpecDispatch tagSpecDispatch = context.getRules().dispatchForTagName(encounteredTag.upperName());
        ArrayList<ParsedTagSpec> filteredTagSpecs = new ArrayList<ParsedTagSpec>();
        if (tagSpecDispatch != null) {
            for (Integer tagSpecId : tagSpecDispatch.allTagSpecs()) {
                ParsedTagSpec parsedTagSpec = context.getRules().getByTagSpecId(tagSpecId);
                if (!parsedTagSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers())) continue;
                filteredTagSpecs.add(parsedTagSpec);
            }
        }
        if (tagSpecDispatch == null || !tagSpecDispatch.hasDispatchKeys() && filteredTagSpecs.size() == 0) {
            result = ValidatorProtos.ValidationResult.newBuilder();
            String specUrl = "";
            if (encounteredTag.upperName().equals("FONT")) {
                specUrl = context.getRules().getStylesSpecUrl();
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(encounteredTag.lowerName());
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_TAG, context.getLineCol(), params, specUrl, result);
            return new ValidateTagResult(result, null);
        }
        if (tagSpecDispatch.hasDispatchKeys()) {
            for (int i = 0; i < encounteredTag.attrs().getLength(); ++i) {
                String name = encounteredTag.attrs().getLocalName(i);
                String value = encounteredTag.attrs().getValue(i);
                List<Integer> tagSpecIds = tagSpecDispatch.matchingDispatchKey(name, value.toLowerCase(), context.getTagStack().parentTagName());
                ValidatorProtos.ValidationResult.Builder validationResult = ValidatorProtos.ValidationResult.newBuilder();
                ValidateTagResult ret = new ValidateTagResult(validationResult, null);
                validationResult.setStatus(ValidatorProtos.ValidationResult.Status.UNKNOWN);
                for (Integer tagSpecId : tagSpecIds) {
                    ParsedTagSpec parsedTagSpec = context.getRules().getByTagSpecId(tagSpecId);
                    if (!parsedTagSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers())) continue;
                    ValidateTagResult resultForAttempt = TagSpecUtils.validateTagAgainstSpec(parsedTagSpec, bestMatchReferencePoint, context, encounteredTag);
                    if (!context.getRules().betterValidationResultThan(resultForAttempt.getValidationResult(), ret.getValidationResult())) continue;
                    ret.setBestMatchTagSpec(parsedTagSpec);
                    ret.setValidationResult(resultForAttempt.getValidationResult());
                    ret.setInlineStyleCssBytes(resultForAttempt.getInlineStyleCssBytes());
                    if (ret.getValidationResult().getStatus() != ValidatorProtos.ValidationResult.Status.PASS) continue;
                    return ret;
                }
                if (ret.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.UNKNOWN) continue;
                return ret;
            }
        }
        if (filteredTagSpecs.size() == 0) {
            result = ValidatorProtos.ValidationResult.newBuilder();
            if (encounteredTag.upperName().equals("SCRIPT")) {
                context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_SCRIPT_TAG, context.getLineCol(), new ArrayList<String>(), context.getRules().getScriptSpecUrl(), result);
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(encounteredTag.lowerName());
                context.addError(ValidatorProtos.ValidationError.Code.GENERAL_DISALLOWED_TAG, context.getLineCol(), params, "", result);
            }
            return new ValidateTagResult(result, null);
        }
        ValidatorProtos.ValidationResult.Builder resultForBestAttempt = ValidatorProtos.ValidationResult.newBuilder();
        resultForBestAttempt.setStatus(ValidatorProtos.ValidationResult.Status.UNKNOWN);
        ParsedTagSpec bestMatchTagSpec = null;
        for (ParsedTagSpec parsedTagSpec : filteredTagSpecs) {
            ValidateTagResult resultForAttempt = TagSpecUtils.validateTagAgainstSpec(parsedTagSpec, bestMatchReferencePoint, context, encounteredTag);
            if (!context.getRules().betterValidationResultThan(resultForAttempt.getValidationResult(), resultForBestAttempt)) continue;
            resultForBestAttempt = resultForAttempt.getValidationResult();
            bestMatchTagSpec = parsedTagSpec;
            if (resultForBestAttempt.getStatus() != ValidatorProtos.ValidationResult.Status.PASS) continue;
            return new ValidateTagResult(resultForBestAttempt, bestMatchTagSpec);
        }
        return new ValidateTagResult(resultForBestAttempt, bestMatchTagSpec);
    }

    public static ValidateTagResult validateTagAgainstSpec(@Nonnull ParsedTagSpec parsedTagSpec, ParsedTagSpec bestMatchReferencePoint, @Nonnull Context context, @Nonnull ParsedHtmlTag encounteredTag) throws TagValidationException, IOException, CssValidationException {
        ValidatorProtos.ValidationResult.Builder resultForAttempt = ValidatorProtos.ValidationResult.newBuilder();
        ValidateTagResult wrapperResult = new ValidateTagResult(resultForAttempt, null);
        resultForAttempt.setStatus(ValidatorProtos.ValidationResult.Status.PASS);
        TagSpecUtils.validateParentTag(parsedTagSpec, context, resultForAttempt);
        TagSpecUtils.validateAncestorTags(parsedTagSpec, context, resultForAttempt);
        context.getTagStack().matchChildTagName(encounteredTag, context, resultForAttempt);
        if (resultForAttempt.getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            AttributeSpecUtils.validateAttributes(parsedTagSpec, bestMatchReferencePoint, context, encounteredTag, wrapperResult);
        }
        if (resultForAttempt.getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            TagSpecUtils.validateDescendantTags(encounteredTag, parsedTagSpec, context, resultForAttempt);
        }
        TagSpecUtils.validateNoSiblingsAllowedTags(parsedTagSpec, context, resultForAttempt);
        TagSpecUtils.validateLastChildTags(context, resultForAttempt);
        if (context.getTagStack().hasAncestor("BODY")) {
            TagSpecUtils.validateRequiredExtensions(parsedTagSpec, context, resultForAttempt);
        }
        if (resultForAttempt.getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            TagSpecUtils.validateUniqueness(parsedTagSpec, context, resultForAttempt);
        }
        if (resultForAttempt.getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
            ArrayList<String> params = new ArrayList<String>();
            if (tagSpec.hasDeprecation()) {
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                params.add(tagSpec.getDeprecation());
                context.addWarning(ValidatorProtos.ValidationError.Code.DEPRECATED_TAG, context.getLineCol(), params, tagSpec.getDeprecationUrl(), resultForAttempt);
            }
            if (tagSpec.hasUniqueWarning() && context.hasTagspecsValidated(parsedTagSpec.getId())) {
                params.clear();
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                context.addWarning(ValidatorProtos.ValidationError.Code.DUPLICATE_UNIQUE_TAG_WARNING, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), resultForAttempt);
            }
        }
        return wrapperResult;
    }

    public static void validateParentTag(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
        if (spec.hasMandatoryParent() && !spec.getMandatoryParent().equals(context.getTagStack().parentTagName())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(context.getTagStack().parentTagName().toLowerCase());
            params.add(spec.getMandatoryParent().toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.WRONG_PARENT_TAG, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
        }
    }

    public static void validateAncestorTags(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
        if (spec.hasMandatoryAncestor()) {
            String mandatoryAncestor = spec.getMandatoryAncestor();
            if (!context.getTagStack().hasAncestor(mandatoryAncestor)) {
                if (spec.hasMandatoryAncestorSuggestedAlternative()) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(TagSpecUtils.getTagSpecName(spec));
                    params.add(mandatoryAncestor.toLowerCase());
                    params.add(spec.getMandatoryAncestorSuggestedAlternative().toLowerCase());
                    context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_TAG_ANCESTOR_WITH_HINT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
                } else {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(TagSpecUtils.getTagSpecName(spec));
                    params.add(mandatoryAncestor.toLowerCase());
                    context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_TAG_ANCESTOR, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
                }
                return;
            }
        }
        for (String disallowedAncestor : spec.getDisallowedAncestorList()) {
            if (!context.getTagStack().hasAncestor(disallowedAncestor)) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(disallowedAncestor.toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_TAG_ANCESTOR, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
            return;
        }
    }

    public static ValidatorProtos.AmpLayout.Layout parseLayout(String layout) {
        if (layout == null) {
            return ValidatorProtos.AmpLayout.Layout.UNKNOWN;
        }
        String normLayout = layout.toUpperCase().replace('-', '_');
        if (ValidatorProtos.AmpLayout.Layout.getDescriptor().findValueByName(normLayout) == null) {
            return ValidatorProtos.AmpLayout.Layout.UNKNOWN;
        }
        return ValidatorProtos.AmpLayout.Layout.valueOf(normLayout);
    }

    public static CssLength calculateHeight(@Nonnull ValidatorProtos.AmpLayout spec, @Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength inputHeight) {
        if ((inputLayout == ValidatorProtos.AmpLayout.Layout.UNKNOWN || inputLayout == ValidatorProtos.AmpLayout.Layout.FIXED || inputLayout == ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT) && !inputHeight.isSet() && spec.hasDefinesDefaultHeight()) {
            return new CssLength("1px", false, false);
        }
        return inputHeight;
    }

    public static ValidatorProtos.AmpLayout.Layout calculateLayout(@Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength width, @Nonnull CssLength height, String sizesAttr, String heightsAttr) {
        if (inputLayout != ValidatorProtos.AmpLayout.Layout.UNKNOWN) {
            return inputLayout;
        }
        if (!width.isSet() && !height.isSet()) {
            return ValidatorProtos.AmpLayout.Layout.CONTAINER;
        }
        if (height.isSet() && height.isFluid() || width.isSet() && width.isFluid()) {
            return ValidatorProtos.AmpLayout.Layout.FLUID;
        }
        if (height.isSet() && (!width.isSet() || width.isAuto())) {
            return ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT;
        }
        if (height.isSet() && width.isSet() && (sizesAttr != null || heightsAttr != null)) {
            return ValidatorProtos.AmpLayout.Layout.RESPONSIVE;
        }
        return ValidatorProtos.AmpLayout.Layout.FIXED;
    }

    public static void validateSsrLayout(@Nonnull ValidatorProtos.TagSpec spec, @Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength inputWidth, @Nonnull CssLength inputHeight, String sizesAttr, String heightsAttr, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        String layoutName;
        String ssrAttr;
        if (!context.isTransformed() || !encounteredTag.lowerName().startsWith("amp-")) {
            return;
        }
        CssLength width = TagSpecUtils.calculateWidthForTag(inputLayout, inputWidth, encounteredTag.upperName());
        CssLength height = TagSpecUtils.calculateHeightForTag(inputLayout, inputHeight, encounteredTag.upperName());
        ValidatorProtos.AmpLayout.Layout layout = TagSpecUtils.calculateLayout(inputLayout, width, height, sizesAttr, heightsAttr);
        HashMap<String, String> attrsByKey = encounteredTag.attrsByKey();
        String classAttr = attrsByKey.get("class");
        if (classAttr != null) {
            String[] classes;
            HashSet<String> validInternalClasses = new HashSet<String>();
            validInternalClasses.add(TagSpecUtils.getLayoutClass(layout));
            if (TagSpecUtils.isLayoutSizeDefined(layout)) {
                validInternalClasses.add(TagSpecUtils.getLayoutSizeDefinedClass());
            }
            for (String classValue : classes = classAttr.split("[\\s+]")) {
                if (!classValue.startsWith("i-amphtml-") || validInternalClasses.contains(classValue)) continue;
                ArrayList<String> params = new ArrayList<String>();
                params.add("class");
                params.add(TagSpecUtils.getTagSpecName(spec));
                params.add(classAttr);
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            }
        }
        if ((ssrAttr = attrsByKey.get("i-amphtml-layout")) != null && !(layoutName = layout.name()).equals(ssrAttr.toLowerCase())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(ssrAttr);
            params.add("i-amphtml-layout");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(layoutName.toUpperCase());
            params.add(layoutName);
            context.addError(ValidatorProtos.ValidationError.Code.ATTR_VALUE_REQUIRED_BY_LAYOUT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
        }
    }

    public static boolean isLayoutSizeDefined(@Nonnull ValidatorProtos.AmpLayout.Layout layout) {
        return layout == ValidatorProtos.AmpLayout.Layout.FILL || layout == ValidatorProtos.AmpLayout.Layout.FIXED || layout == ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT || layout == ValidatorProtos.AmpLayout.Layout.FLEX_ITEM || layout == ValidatorProtos.AmpLayout.Layout.FLUID || layout == ValidatorProtos.AmpLayout.Layout.INTRINSIC || layout == ValidatorProtos.AmpLayout.Layout.RESPONSIVE;
    }

    public static String getLayoutClass(@Nonnull ValidatorProtos.AmpLayout.Layout layout) {
        return "i-amphtml-layout-" + layout.name();
    }

    public static String getLayoutSizeDefinedClass() {
        return "i-amphtml-layout-size-defined";
    }

    public static CssLength calculateWidthForTag(@Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength inputWidth, @Nonnull String tagName) {
        if (!(inputLayout != ValidatorProtos.AmpLayout.Layout.UNKNOWN && inputLayout != ValidatorProtos.AmpLayout.Layout.FIXED || inputWidth.isSet())) {
            if (tagName.equals("AMP-ANALYTICS") || tagName.equals("AMP-PIXEL")) {
                return new CssLength("1px", false, false);
            }
            if (tagName.equals("AMP-SOCIAL-SHARE")) {
                return new CssLength("60px", false, false);
            }
        }
        return inputWidth;
    }

    public static CssLength calculateHeightForTag(@Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength inputHeight, @Nonnull String tagName) {
        if (!(inputLayout != ValidatorProtos.AmpLayout.Layout.UNKNOWN && inputLayout != ValidatorProtos.AmpLayout.Layout.FIXED && inputLayout != ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT || inputHeight.isSet())) {
            if (tagName.equals("AMP-ANALYTICS") || tagName.equals("AMP-PIXEL")) {
                return new CssLength("1px", false, false);
            }
            if (tagName.equals("AMP-SOCIAL-SHARE")) {
                return new CssLength("44px", false, false);
            }
        }
        return inputHeight;
    }

    public static CssLength calculateWidth(@Nonnull ValidatorProtos.AmpLayout spec, @Nonnull ValidatorProtos.AmpLayout.Layout inputLayout, @Nonnull CssLength inputWidth) {
        if ((inputLayout == ValidatorProtos.AmpLayout.Layout.UNKNOWN || inputLayout == ValidatorProtos.AmpLayout.Layout.FIXED) && !inputWidth.isSet() && spec.hasDefinesDefaultWidth()) {
            return new CssLength("1px", false, false);
        }
        return inputWidth;
    }

    public static void validateDescendantTags(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        TagStack tagStack = context.getTagStack();
        for (DescendantConstraints allowedDescendantsList : tagStack.allowedDescendantsList()) {
            if (allowedDescendantsList.getAllowedTags().contains(encounteredTag.upperName())) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(encounteredTag.lowerName());
            params.add(allowedDescendantsList.getTagName().toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_TAG_ANCESTOR, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
            return;
        }
    }

    public static void validateNoSiblingsAllowedTags(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        ArrayList<String> params;
        ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
        TagStack tagStack = context.getTagStack();
        if (spec.hasSiblingsDisallowed() && tagStack.parentChildCount() > 0) {
            params = new ArrayList<String>();
            params.add(spec.getTagName().toLowerCase());
            params.add(tagStack.parentTagName().toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.TAG_NOT_ALLOWED_TO_HAVE_SIBLINGS, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
        }
        if (tagStack.parentHasChildWithNoSiblingRule() && tagStack.parentChildCount() > 0) {
            params = new ArrayList();
            params.add(tagStack.parentOnlyChildTagName().toLowerCase());
            params.add(tagStack.parentTagName().toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.TAG_NOT_ALLOWED_TO_HAVE_SIBLINGS, tagStack.parentOnlyChildErrorLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), validationResult);
        }
    }

    public static void validateLastChildTags(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException {
        TagStack tagStack = context.getTagStack();
        if (tagStack.parentHasChildWithLastChildRule()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(tagStack.parentLastChildTagName().toLowerCase());
            params.add(tagStack.parentTagName().toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_LAST_CHILD_TAG, tagStack.parentLastChildErrorLineCol(), params, tagStack.parentLastChildUrl(), validationResult);
        }
    }

    public static void validateRequiredExtensions(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
        ExtensionsContext extensionsCtx = context.getExtensions();
        for (String requiredExtension : tagSpec.getRequiresExtensionList()) {
            if (extensionsCtx.isExtensionLoaded(requiredExtension)) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
            params.add(requiredExtension);
            context.addError(ValidatorProtos.ValidationError.Code.MISSING_REQUIRED_EXTENSION, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
        }
    }

    public static void validateUniqueness(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
        if (tagSpec.hasUnique() && context.getTagspecsValidated().containsKey(parsedTagSpec.id())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            context.addError(ValidatorProtos.ValidationError.Code.DUPLICATE_UNIQUE_TAG, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), validationResult);
        }
    }
}

