/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.Canonicalizer;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.EOFToken;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.TokenStream;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.selector.AttrSelector;
import dev.amp.validator.selector.ClassSelector;
import dev.amp.validator.selector.Combinator;
import dev.amp.validator.selector.IdSelector;
import dev.amp.validator.selector.PseudoSelector;
import dev.amp.validator.selector.Selector;
import dev.amp.validator.selector.SelectorException;
import dev.amp.validator.selector.SimpleSelectorSequence;
import dev.amp.validator.selector.TypeSelector;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class SelectorUtils {
    private SelectorUtils() {
    }

    public static boolean isSimpleSelectorSequenceStart(@Nonnull Token token) {
        if (SelectorUtils.isDelim(token, "*") || SelectorUtils.isDelim(token, "|") || CssTokenUtil.getTokenType(token) == TokenType.IDENT) {
            return true;
        }
        if (CssTokenUtil.getTokenType(token) == TokenType.HASH) {
            return true;
        }
        if (SelectorUtils.isDelim(token, ".")) {
            return true;
        }
        if (CssTokenUtil.getTokenType(token) == TokenType.OPEN_SQUARE) {
            return true;
        }
        return CssTokenUtil.getTokenType(token) == TokenType.COLON;
    }

    public static boolean isDelim(@Nonnull Token token, @Nonnull String delimChar) {
        return CssTokenUtil.getTokenType(token) == TokenType.DELIM && token.image.equals(delimChar);
    }

    public static SimpleSelectorSequence parseASimpleSelectorSequence(@Nonnull TokenStream tokenStream) throws SelectorException, CssValidationException {
        Token start = tokenStream.current();
        TypeSelector typeSelector = null;
        if (SelectorUtils.isDelim(tokenStream.current(), "*") || SelectorUtils.isDelim(tokenStream.current(), "|") || CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT) {
            typeSelector = SelectorUtils.parseATypeSelector(tokenStream);
        }
        ArrayList<Selector> otherSelectors = new ArrayList<Selector>();
        while (true) {
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.HASH) {
                otherSelectors.add(SelectorUtils.parseAnIdSelector(tokenStream));
                continue;
            }
            if (SelectorUtils.isDelim(tokenStream.current(), ".") && CssTokenUtil.getTokenType(tokenStream.next()) == TokenType.IDENT) {
                otherSelectors.add(SelectorUtils.parseAClassSelector(tokenStream));
                continue;
            }
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.OPEN_SQUARE) {
                AttrSelector maybeAttrSelector = SelectorUtils.parseAnAttrSelector(tokenStream);
                otherSelectors.add(maybeAttrSelector);
                continue;
            }
            if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.COLON) break;
            PseudoSelector maybePseudo = SelectorUtils.parseAPseudoSelector(tokenStream);
            otherSelectors.add(maybePseudo);
        }
        if (typeSelector == null) {
            if (otherSelectors.size() == 0) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("style");
                ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_MISSING_SELECTOR, params);
                throw new SelectorException((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), errorToken));
            }
            typeSelector = (TypeSelector)CssTokenUtil.copyPosTo(start, new TypeSelector(null, "*"));
        }
        return (SimpleSelectorSequence)CssTokenUtil.copyPosTo(start, new SimpleSelectorSequence(typeSelector, otherSelectors));
    }

    private static PseudoSelector parseAPseudoSelector(@Nonnull TokenStream tokenStream) throws SelectorException, CssValidationException {
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.COLON) {
            throw new SelectorException("Precondition violated: must be a \":\"");
        }
        Token firstColon = tokenStream.current();
        tokenStream.consume();
        boolean isClass = true;
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.COLON) {
            isClass = false;
            tokenStream.consume();
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT) {
            Token ident = tokenStream.current();
            String name = ident.image;
            tokenStream.consume();
            return (PseudoSelector)CssTokenUtil.copyPosTo(firstColon, new PseudoSelector(isClass, name, new ArrayList<Token>()));
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.FUNCTION_TOKEN) {
            Token funcToken = tokenStream.current();
            ArrayList<ErrorToken> errors = new ArrayList<ErrorToken>();
            List<Token> func = SelectorUtils.extractAFunction(tokenStream, errors);
            if (errors.size() > 0) {
                throw new SelectorException((ErrorToken)((Object)errors.get(0)));
            }
            tokenStream.consume();
            return (PseudoSelector)CssTokenUtil.copyPosTo(firstColon, new PseudoSelector(isClass, funcToken.image, func));
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("style");
        ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_ERROR_IN_PSEUDO_SELECTOR, params);
        throw new SelectorException((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), errorToken));
    }

    public static Selector parseASelector(@Nonnull TokenStream tokenStream) throws CssValidationException, SelectorException {
        SimpleSelectorSequence parsed;
        if (!SelectorUtils.isSimpleSelectorSequenceStart(tokenStream.current())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_NOT_A_SELECTOR_START, params);
            throw new SelectorException((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), errorToken));
        }
        try {
            parsed = SelectorUtils.parseASimpleSelectorSequence(tokenStream);
        }
        catch (SelectorException selectorException) {
            throw selectorException;
        }
        catch (CssValidationException cssValidationException) {
            throw cssValidationException;
        }
        Selector left = parsed;
        while (true) {
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE && !SelectorUtils.isSimpleSelectorSequenceStart(tokenStream.next())) {
                tokenStream.consume();
            }
            if (!(CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE && SelectorUtils.isSimpleSelectorSequenceStart(tokenStream.next()) || SelectorUtils.isDelim(tokenStream.current(), "+") || SelectorUtils.isDelim(tokenStream.current(), ">") || SelectorUtils.isDelim(tokenStream.current(), "~"))) {
                return left;
            }
            Token combinatorToken = tokenStream.current();
            tokenStream.consume();
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
                tokenStream.consume();
            }
            SimpleSelectorSequence right = SelectorUtils.parseASimpleSelectorSequence(tokenStream);
            left = (Selector)CssTokenUtil.copyPosTo(combinatorToken, new Combinator(SelectorUtils.combinatorTypeForToken(combinatorToken), left, right));
        }
    }

    public static Combinator.CombinatorType combinatorTypeForToken(@Nonnull Token token) throws CssValidationException {
        if (CssTokenUtil.getTokenType(token) == TokenType.WHITESPACE) {
            return Combinator.CombinatorType.DESCENDANT;
        }
        if (SelectorUtils.isDelim(token, ">")) {
            return Combinator.CombinatorType.CHILD;
        }
        if (SelectorUtils.isDelim(token, "+")) {
            return Combinator.CombinatorType.ADJACENT_SIBLING;
        }
        if (SelectorUtils.isDelim(token, "~")) {
            return Combinator.CombinatorType.GENERAL_SIBLING;
        }
        throw new CssValidationException("'Internal Error: not a combinator token");
    }

    public static TypeSelector parseATypeSelector(@Nonnull TokenStream tokenStream) {
        Token ident;
        String namespacePrefix = null;
        String elementName = "*";
        Token start = tokenStream.current();
        if (SelectorUtils.isDelim(tokenStream.current(), "|")) {
            namespacePrefix = "";
            tokenStream.consume();
        } else if (SelectorUtils.isDelim(tokenStream.current(), "*") && SelectorUtils.isDelim(tokenStream.next(), "|")) {
            namespacePrefix = "*";
            tokenStream.consume();
            tokenStream.consume();
        } else if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT && SelectorUtils.isDelim(tokenStream.next(), "|")) {
            ident = tokenStream.current();
            namespacePrefix = ident.image;
            tokenStream.consume();
            tokenStream.consume();
        }
        if (SelectorUtils.isDelim(tokenStream.current(), "*")) {
            elementName = "*";
            tokenStream.consume();
        } else if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT) {
            ident = tokenStream.current();
            elementName = ident.image;
            tokenStream.consume();
        }
        return (TypeSelector)CssTokenUtil.copyPosTo(start, new TypeSelector(namespacePrefix, elementName));
    }

    private static Selector parseAnIdSelector(@Nonnull TokenStream tokenStream) throws SelectorException {
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.HASH) {
            throw new SelectorException("Precondition violated: must start with HashToken");
        }
        Token hash = tokenStream.current();
        tokenStream.consume();
        return (Selector)CssTokenUtil.copyPosTo(hash, new IdSelector(hash.image));
    }

    private static ClassSelector parseAClassSelector(@Nonnull TokenStream tokenStream) throws SelectorException {
        if (CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.IDENT || !SelectorUtils.isDelim(tokenStream.current(), ".")) {
            throw new SelectorException("Precondition violated: must start with \".\" and follow with ident");
        }
        Token dot = tokenStream.current();
        tokenStream.consume();
        Token ident = tokenStream.current();
        tokenStream.consume();
        return (ClassSelector)CssTokenUtil.copyPosTo(dot, new ClassSelector(ident.image));
    }

    public static AttrSelector parseAnAttrSelector(@Nonnull TokenStream tokenStream) throws SelectorException, CssValidationException {
        Token ident;
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.OPEN_SQUARE) {
            throw new SelectorException("Precondition violated: must be an OpenSquareToken");
        }
        Token start = tokenStream.current();
        tokenStream.consume();
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
        String namespacePrefix = null;
        if (SelectorUtils.isDelim(tokenStream.current(), "|")) {
            namespacePrefix = "";
            tokenStream.consume();
        } else if (SelectorUtils.isDelim(tokenStream.current(), "*") && SelectorUtils.isDelim(tokenStream.next(), "|")) {
            namespacePrefix = "*";
            tokenStream.consume();
            tokenStream.consume();
        } else if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT && SelectorUtils.isDelim(tokenStream.next(), "|")) {
            ident = tokenStream.current();
            namespacePrefix = ident.image;
            tokenStream.consume();
            tokenStream.consume();
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.IDENT) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_ATTR_SELECTOR, params);
            CssTokenUtil.copyPosTo(tokenStream.current(), errorToken);
            throw new SelectorException(errorToken);
        }
        ident = tokenStream.current();
        String attrName = ident.image;
        tokenStream.consume();
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
        String matchOperator = "";
        TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
        if (SelectorUtils.isDelim(tokenStream.current(), "=")) {
            matchOperator = "=";
            tokenStream.consume();
        } else if (current == TokenType.INCLUDE_MATCH) {
            matchOperator = "~=";
            tokenStream.consume();
        } else if (current == TokenType.DASH_MATCH) {
            matchOperator = "|=";
            tokenStream.consume();
        } else if (current == TokenType.PREFIX_MATCH) {
            matchOperator = "^=";
            tokenStream.consume();
        } else if (current == TokenType.SUFFIX_MATCH) {
            matchOperator = "$=";
            tokenStream.consume();
        } else if (current == TokenType.SUBSTRING_MATCH) {
            matchOperator = "*=";
            tokenStream.consume();
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
        String value = "";
        if (matchOperator.equals("")) {
            current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.IDENT) {
                ident = tokenStream.current();
                value = ident.image;
                tokenStream.consume();
            } else if (current == TokenType.STRING) {
                value = tokenStream.current().image;
                tokenStream.consume();
            }
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.CLOSE_SQUARE) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_ATTR_SELECTOR, params);
            CssTokenUtil.copyPosTo(tokenStream.current(), errorToken);
            throw new SelectorException(errorToken);
        }
        tokenStream.consume();
        AttrSelector selector = new AttrSelector(namespacePrefix, attrName, matchOperator, value);
        return (AttrSelector)CssTokenUtil.copyPosTo(start, selector);
    }

    public static List<Token> extractAFunction(@Nonnull TokenStream tokenStream, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        ArrayList<Token> consumedTokens = new ArrayList<Token>();
        if (!Canonicalizer.consumeAFunction(tokenStream, consumedTokens, 0)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params);
            CssTokenUtil.copyPosTo(tokenStream.current(), errorToken);
            errors.add(errorToken);
        }
        if (consumedTokens.size() < 2) {
            throw new CssValidationException("Internal Error: extractAFunction precondition not met");
        }
        int end = consumedTokens.size() - 1;
        consumedTokens.set(end, CssTokenUtil.copyPosTo((Token)consumedTokens.get(end), new EOFToken()));
        return consumedTokens;
    }
}

