/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.Context;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ValidatorProtos;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class ExtensionsUtils {
    public static final String[] EXTENSION_SCRIPT_NAMES = new String[]{"custom-element", "custom-template", "host-service"};

    private ExtensionsUtils() {
    }

    public static boolean isAsyncScriptTag(ParsedHtmlTag tag) {
        return "SCRIPT".equals(tag.upperName()) && tag.attrsByKey().containsKey("async") && tag.attrsByKey().containsKey("src");
    }

    public static void validateScriptSrcAttr(@Nonnull ParsedHtmlTag tag, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        if (context.getScriptReleaseVersion() == ScriptReleaseVersion.UNKNOWN) {
            return;
        }
        ScriptReleaseVersion scriptReleaseVersion = ExtensionsUtils.getScriptReleaseVersion(tag);
        if (context.getScriptReleaseVersion() != scriptReleaseVersion) {
            ArrayList<String> params = new ArrayList<String>();
            String specName = tagSpec.hasExtensionSpec() ? tagSpec.getExtensionSpec().getName() : tagSpec.getSpecName();
            params.add(specName);
            context.addError(scriptReleaseVersion == ScriptReleaseVersion.LTS ? ValidatorProtos.ValidationError.Code.LTS_SCRIPT_AFTER_NON_LTS : ValidatorProtos.ValidationError.Code.NON_LTS_SCRIPT_AFTER_LTS, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", result);
        }
    }

    public static ScriptReleaseVersion getScriptReleaseVersion(@Nonnull ParsedHtmlTag tag) {
        if (tag.isModuleLtsScriptTag() || tag.isNomoduleLtsScriptTag()) {
            return ScriptReleaseVersion.MODULE_NOMODULE_LTS;
        }
        if (tag.isModuleScriptTag() || tag.isNomoduleScriptTag()) {
            return ScriptReleaseVersion.MODULE_NOMODULE;
        }
        if (tag.isLtsScriptTag()) {
            return ScriptReleaseVersion.LTS;
        }
        return ScriptReleaseVersion.STANDARD;
    }

    public static enum ScriptReleaseVersion {
        UNKNOWN,
        STANDARD,
        LTS,
        MODULE_NOMODULE,
        MODULE_NOMODULE_LTS;

    }
}

