/*
 * Decompiled with CFR 0.152.
 */
package retrofit.http;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import rx.functions.Func1;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.TYPE})
public @interface Retrofit {
    public String value() default "";

    public static class SimpleRequestInterceptor
    implements retrofit.RequestInterceptor {
        public void intercept(RequestInterceptor.RequestFacade request) {
        }

        public void intercept(Object context, RequestInterceptor.RequestFacade request) {
            this.intercept(request);
        }
    }

    public static interface RequestAuthenticator
    extends retrofit.RequestInterceptor {
        public String authorize(Object var1, Collection<String> var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Authenticator {
        public Class<? extends RequestAuthenticator> value() default RequestAuthenticator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Authenticated {
        public Class<? extends RequestAuthenticator> value() default RequestAuthenticator.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Streaming {
    }

    @Documented
    @Target(value={ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RestMethod {
        public String value();

        public boolean hasBody() default false;
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface QueryMap {
        public boolean encodeNames() default false;

        public boolean encodeValues() default true;
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Query {
        public String value();

        public boolean encodeName() default false;

        public boolean encodeValue() default true;
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RestMethod(value="PUT", hasBody=true)
    public static @interface PUT {
        public String value();

        public String[] permissions() default {};
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RestMethod(value="POST", hasBody=true)
    public static @interface POST {
        public String value();

        public String[] permissions() default {};
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Path {
        public String value();

        public boolean encode() default true;
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RestMethod(value="PATCH", hasBody=true)
    public static @interface PATCH {
        public String value();
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PartMap {
        public String encoding() default "binary";
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Part {
        public String value();

        public String encoding() default "binary";

        public String mimeType() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Multipart {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RestMethod(value="HEAD")
    public static @interface HEAD {
        public String value();

        public String[] permissions() default {};
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Headers {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Header {
        public String value();
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RestMethod(value="GET")
    public static @interface GET {
        public String value() default "";

        public String[] permissions() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FormUrlEncoded {
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldMap {
        public boolean encodeNames() default true;

        public boolean encodeValues() default true;
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Field {
        public String value();

        public boolean encodeName() default true;

        public boolean encodeValue() default true;
    }

    @Documented
    @Deprecated
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EncodedQueryMap {
    }

    @Documented
    @Deprecated
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EncodedQuery {
        public String value();
    }

    @Documented
    @Deprecated
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface EncodedPath {
        public String value();
    }

    @Documented
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Body {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @RestMethod(value="DELETE")
    public static @interface DELETE {
        public String value() default "";

        public String[] permissions() default {};
    }

    public static interface Bindable<T>
    extends Func1<T, String> {
        public String call(T var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface RequestInterceptor {
        public Class<? extends retrofit.RequestInterceptor> value() default retrofit.RequestInterceptor.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface QueryBinding {
        public String value() default "";

        public Class<? extends Bindable> binder() default Bindable.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface QueryBundle {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface LogLevel {
        public RestAdapter.LogLevel value() default RestAdapter.LogLevel.NONE;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Converter {
        public Class<? extends retrofit.converter.Converter> value() default retrofit.converter.Converter.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface ErrorHandler {
        public Class<? extends retrofit.ErrorHandler> value() default retrofit.ErrorHandler.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface RetryHeaders {
        public String[] value();

        public Class<? extends Throwable>[] exceptions() default {Throwable.class};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Validate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Builder {
    }
}

