/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resourcegroupstaggingapi.model.ComplianceDetails;
import java.util.List;

@SdkInternalApi
public class ComplianceDetailsMarshaller {
    private static final MarshallingInfo<List> NONCOMPLIANTKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NoncompliantKeys").build();
    private static final MarshallingInfo<List> KEYSWITHNONCOMPLIANTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeysWithNoncompliantValues").build();
    private static final MarshallingInfo<Boolean> COMPLIANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceStatus").build();
    private static final ComplianceDetailsMarshaller instance = new ComplianceDetailsMarshaller();

    public static ComplianceDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ComplianceDetails complianceDetails, ProtocolMarshaller protocolMarshaller) {
        if (complianceDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(complianceDetails.getNoncompliantKeys(), NONCOMPLIANTKEYS_BINDING);
            protocolMarshaller.marshall(complianceDetails.getKeysWithNoncompliantValues(), KEYSWITHNONCOMPLIANTVALUES_BINDING);
            protocolMarshaller.marshall((Object)complianceDetails.getComplianceStatus(), COMPLIANCESTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

