/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.TagFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String paginationToken;
    private List<TagFilter> tagFilters;
    private Integer resourcesPerPage;
    private Integer tagsPerPage;
    private List<String> resourceTypeFilters;
    private Boolean includeComplianceDetails;
    private Boolean excludeCompliantResources;
    private List<String> resourceARNList;

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public GetResourcesRequest withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public List<TagFilter> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(Collection<TagFilter> tagFilters) {
        if (tagFilters == null) {
            this.tagFilters = null;
            return;
        }
        this.tagFilters = new ArrayList<TagFilter>(tagFilters);
    }

    public GetResourcesRequest withTagFilters(TagFilter ... tagFilters) {
        if (this.tagFilters == null) {
            this.setTagFilters(new ArrayList<TagFilter>(tagFilters.length));
        }
        for (TagFilter ele : tagFilters) {
            this.tagFilters.add(ele);
        }
        return this;
    }

    public GetResourcesRequest withTagFilters(Collection<TagFilter> tagFilters) {
        this.setTagFilters(tagFilters);
        return this;
    }

    public void setResourcesPerPage(Integer resourcesPerPage) {
        this.resourcesPerPage = resourcesPerPage;
    }

    public Integer getResourcesPerPage() {
        return this.resourcesPerPage;
    }

    public GetResourcesRequest withResourcesPerPage(Integer resourcesPerPage) {
        this.setResourcesPerPage(resourcesPerPage);
        return this;
    }

    public void setTagsPerPage(Integer tagsPerPage) {
        this.tagsPerPage = tagsPerPage;
    }

    public Integer getTagsPerPage() {
        return this.tagsPerPage;
    }

    public GetResourcesRequest withTagsPerPage(Integer tagsPerPage) {
        this.setTagsPerPage(tagsPerPage);
        return this;
    }

    public List<String> getResourceTypeFilters() {
        return this.resourceTypeFilters;
    }

    public void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
        if (resourceTypeFilters == null) {
            this.resourceTypeFilters = null;
            return;
        }
        this.resourceTypeFilters = new ArrayList<String>(resourceTypeFilters);
    }

    public GetResourcesRequest withResourceTypeFilters(String ... resourceTypeFilters) {
        if (this.resourceTypeFilters == null) {
            this.setResourceTypeFilters(new ArrayList<String>(resourceTypeFilters.length));
        }
        for (String ele : resourceTypeFilters) {
            this.resourceTypeFilters.add(ele);
        }
        return this;
    }

    public GetResourcesRequest withResourceTypeFilters(Collection<String> resourceTypeFilters) {
        this.setResourceTypeFilters(resourceTypeFilters);
        return this;
    }

    public void setIncludeComplianceDetails(Boolean includeComplianceDetails) {
        this.includeComplianceDetails = includeComplianceDetails;
    }

    public Boolean getIncludeComplianceDetails() {
        return this.includeComplianceDetails;
    }

    public GetResourcesRequest withIncludeComplianceDetails(Boolean includeComplianceDetails) {
        this.setIncludeComplianceDetails(includeComplianceDetails);
        return this;
    }

    public Boolean isIncludeComplianceDetails() {
        return this.includeComplianceDetails;
    }

    public void setExcludeCompliantResources(Boolean excludeCompliantResources) {
        this.excludeCompliantResources = excludeCompliantResources;
    }

    public Boolean getExcludeCompliantResources() {
        return this.excludeCompliantResources;
    }

    public GetResourcesRequest withExcludeCompliantResources(Boolean excludeCompliantResources) {
        this.setExcludeCompliantResources(excludeCompliantResources);
        return this;
    }

    public Boolean isExcludeCompliantResources() {
        return this.excludeCompliantResources;
    }

    public List<String> getResourceARNList() {
        return this.resourceARNList;
    }

    public void setResourceARNList(Collection<String> resourceARNList) {
        if (resourceARNList == null) {
            this.resourceARNList = null;
            return;
        }
        this.resourceARNList = new ArrayList<String>(resourceARNList);
    }

    public GetResourcesRequest withResourceARNList(String ... resourceARNList) {
        if (this.resourceARNList == null) {
            this.setResourceARNList(new ArrayList<String>(resourceARNList.length));
        }
        for (String ele : resourceARNList) {
            this.resourceARNList.add(ele);
        }
        return this;
    }

    public GetResourcesRequest withResourceARNList(Collection<String> resourceARNList) {
        this.setResourceARNList(resourceARNList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken()).append(",");
        }
        if (this.getTagFilters() != null) {
            sb.append("TagFilters: ").append(this.getTagFilters()).append(",");
        }
        if (this.getResourcesPerPage() != null) {
            sb.append("ResourcesPerPage: ").append(this.getResourcesPerPage()).append(",");
        }
        if (this.getTagsPerPage() != null) {
            sb.append("TagsPerPage: ").append(this.getTagsPerPage()).append(",");
        }
        if (this.getResourceTypeFilters() != null) {
            sb.append("ResourceTypeFilters: ").append(this.getResourceTypeFilters()).append(",");
        }
        if (this.getIncludeComplianceDetails() != null) {
            sb.append("IncludeComplianceDetails: ").append(this.getIncludeComplianceDetails()).append(",");
        }
        if (this.getExcludeCompliantResources() != null) {
            sb.append("ExcludeCompliantResources: ").append(this.getExcludeCompliantResources()).append(",");
        }
        if (this.getResourceARNList() != null) {
            sb.append("ResourceARNList: ").append(this.getResourceARNList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest)obj;
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        if (other.getPaginationToken() != null && !other.getPaginationToken().equals(this.getPaginationToken())) {
            return false;
        }
        if (other.getTagFilters() == null ^ this.getTagFilters() == null) {
            return false;
        }
        if (other.getTagFilters() != null && !other.getTagFilters().equals(this.getTagFilters())) {
            return false;
        }
        if (other.getResourcesPerPage() == null ^ this.getResourcesPerPage() == null) {
            return false;
        }
        if (other.getResourcesPerPage() != null && !other.getResourcesPerPage().equals(this.getResourcesPerPage())) {
            return false;
        }
        if (other.getTagsPerPage() == null ^ this.getTagsPerPage() == null) {
            return false;
        }
        if (other.getTagsPerPage() != null && !other.getTagsPerPage().equals(this.getTagsPerPage())) {
            return false;
        }
        if (other.getResourceTypeFilters() == null ^ this.getResourceTypeFilters() == null) {
            return false;
        }
        if (other.getResourceTypeFilters() != null && !other.getResourceTypeFilters().equals(this.getResourceTypeFilters())) {
            return false;
        }
        if (other.getIncludeComplianceDetails() == null ^ this.getIncludeComplianceDetails() == null) {
            return false;
        }
        if (other.getIncludeComplianceDetails() != null && !other.getIncludeComplianceDetails().equals(this.getIncludeComplianceDetails())) {
            return false;
        }
        if (other.getExcludeCompliantResources() == null ^ this.getExcludeCompliantResources() == null) {
            return false;
        }
        if (other.getExcludeCompliantResources() != null && !other.getExcludeCompliantResources().equals(this.getExcludeCompliantResources())) {
            return false;
        }
        if (other.getResourceARNList() == null ^ this.getResourceARNList() == null) {
            return false;
        }
        return other.getResourceARNList() == null || other.getResourceARNList().equals(this.getResourceARNList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        hashCode = 31 * hashCode + (this.getTagFilters() == null ? 0 : this.getTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesPerPage() == null ? 0 : this.getResourcesPerPage().hashCode());
        hashCode = 31 * hashCode + (this.getTagsPerPage() == null ? 0 : this.getTagsPerPage().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypeFilters() == null ? 0 : this.getResourceTypeFilters().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeComplianceDetails() == null ? 0 : this.getIncludeComplianceDetails().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeCompliantResources() == null ? 0 : this.getExcludeCompliantResources().hashCode());
        hashCode = 31 * hashCode + (this.getResourceARNList() == null ? 0 : this.getResourceARNList().hashCode());
        return hashCode;
    }

    public GetResourcesRequest clone() {
        return (GetResourcesRequest)super.clone();
    }
}

