/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.AcceleratorStatus;
import com.amazonaws.services.globalaccelerator.model.IpAddressType;
import com.amazonaws.services.globalaccelerator.model.IpSet;
import com.amazonaws.services.globalaccelerator.model.transform.AcceleratorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Accelerator
implements Serializable,
Cloneable,
StructuredPojo {
    private String acceleratorArn;
    private String name;
    private String ipAddressType;
    private Boolean enabled;
    private List<IpSet> ipSets;
    private String status;
    private Date createdTime;
    private Date lastModifiedTime;

    public void setAcceleratorArn(String acceleratorArn) {
        this.acceleratorArn = acceleratorArn;
    }

    public String getAcceleratorArn() {
        return this.acceleratorArn;
    }

    public Accelerator withAcceleratorArn(String acceleratorArn) {
        this.setAcceleratorArn(acceleratorArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Accelerator withName(String name) {
        this.setName(name);
        return this;
    }

    public void setIpAddressType(String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public Accelerator withIpAddressType(String ipAddressType) {
        this.setIpAddressType(ipAddressType);
        return this;
    }

    public Accelerator withIpAddressType(IpAddressType ipAddressType) {
        this.ipAddressType = ipAddressType.toString();
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Accelerator withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<IpSet> getIpSets() {
        return this.ipSets;
    }

    public void setIpSets(Collection<IpSet> ipSets) {
        if (ipSets == null) {
            this.ipSets = null;
            return;
        }
        this.ipSets = new ArrayList<IpSet>(ipSets);
    }

    public Accelerator withIpSets(IpSet ... ipSets) {
        if (this.ipSets == null) {
            this.setIpSets(new ArrayList<IpSet>(ipSets.length));
        }
        for (IpSet ele : ipSets) {
            this.ipSets.add(ele);
        }
        return this;
    }

    public Accelerator withIpSets(Collection<IpSet> ipSets) {
        this.setIpSets(ipSets);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Accelerator withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Accelerator withStatus(AcceleratorStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Accelerator withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Accelerator withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceleratorArn() != null) {
            sb.append("AcceleratorArn: ").append(this.getAcceleratorArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIpAddressType() != null) {
            sb.append("IpAddressType: ").append(this.getIpAddressType()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getIpSets() != null) {
            sb.append("IpSets: ").append(this.getIpSets()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Accelerator)) {
            return false;
        }
        Accelerator other = (Accelerator)obj;
        if (other.getAcceleratorArn() == null ^ this.getAcceleratorArn() == null) {
            return false;
        }
        if (other.getAcceleratorArn() != null && !other.getAcceleratorArn().equals(this.getAcceleratorArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIpAddressType() == null ^ this.getIpAddressType() == null) {
            return false;
        }
        if (other.getIpAddressType() != null && !other.getIpAddressType().equals(this.getIpAddressType())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getIpSets() == null ^ this.getIpSets() == null) {
            return false;
        }
        if (other.getIpSets() != null && !other.getIpSets().equals(this.getIpSets())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        return other.getLastModifiedTime() == null || other.getLastModifiedTime().equals(this.getLastModifiedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceleratorArn() == null ? 0 : this.getAcceleratorArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddressType() == null ? 0 : this.getIpAddressType().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getIpSets() == null ? 0 : this.getIpSets().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        return hashCode;
    }

    public Accelerator clone() {
        try {
            return (Accelerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AcceleratorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

