/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.AutoRollbackEvent;
import com.amazonaws.services.codedeploy.model.transform.AutoRollbackConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AutoRollbackConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private SdkInternalList<String> events;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public AutoRollbackConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList(events);
    }

    public AutoRollbackConfiguration withEvents(String ... events) {
        if (this.events == null) {
            this.setEvents((Collection<String>)new SdkInternalList(events.length));
        }
        for (String ele : events) {
            this.events.add((Object)ele);
        }
        return this;
    }

    public AutoRollbackConfiguration withEvents(Collection<String> events) {
        this.setEvents(events);
        return this;
    }

    public AutoRollbackConfiguration withEvents(AutoRollbackEvent ... events) {
        SdkInternalList eventsCopy = new SdkInternalList(events.length);
        for (AutoRollbackEvent value : events) {
            eventsCopy.add((Object)value.toString());
        }
        if (this.getEvents() == null) {
            this.setEvents((Collection<String>)eventsCopy);
        } else {
            this.getEvents().addAll((Collection<String>)eventsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRollbackConfiguration)) {
            return false;
        }
        AutoRollbackConfiguration other = (AutoRollbackConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public AutoRollbackConfiguration clone() {
        try {
            return (AutoRollbackConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoRollbackConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

