/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.ListDeploymentInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDeploymentInstancesRequestMarshaller
implements Marshaller<Request<ListDeploymentInstancesRequest>, ListDeploymentInstancesRequest> {
    public Request<ListDeploymentInstancesRequest> marshall(ListDeploymentInstancesRequest listDeploymentInstancesRequest) {
        if (listDeploymentInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDeploymentInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListDeploymentInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceStatusFilterList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listDeploymentInstancesRequest.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(listDeploymentInstancesRequest.getDeploymentId());
            }
            if (listDeploymentInstancesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listDeploymentInstancesRequest.getNextToken());
            }
            if (!(instanceStatusFilterList = (SdkInternalList)listDeploymentInstancesRequest.getInstanceStatusFilter()).isEmpty() || !instanceStatusFilterList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("instanceStatusFilter");
                jsonGenerator.writeStartArray();
                for (String instanceStatusFilterListValue : instanceStatusFilterList) {
                    if (instanceStatusFilterListValue == null) continue;
                    jsonGenerator.writeValue(instanceStatusFilterListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

