/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRepositoriesRequestMarshaller
implements Marshaller<Request<ListRepositoriesRequest>, ListRepositoriesRequest> {
    public Request<ListRepositoriesRequest> marshall(ListRepositoriesRequest listRepositoriesRequest) {
        if (listRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.ListRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listRepositoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listRepositoriesRequest.getNextToken());
            }
            if (listRepositoriesRequest.getSortBy() != null) {
                jsonGenerator.writeFieldName("sortBy").writeValue(listRepositoriesRequest.getSortBy());
            }
            if (listRepositoriesRequest.getOrder() != null) {
                jsonGenerator.writeFieldName("order").writeValue(listRepositoriesRequest.getOrder());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

