/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudtrail.AWSCloudTrail;
import com.amazonaws.services.cloudtrail.model.AWSCloudTrailException;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.AddTagsResult;
import com.amazonaws.services.cloudtrail.model.CloudTrailARNInvalidException;
import com.amazonaws.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import com.amazonaws.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import com.amazonaws.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import com.amazonaws.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import com.amazonaws.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import com.amazonaws.services.cloudtrail.model.InvalidHomeRegionException;
import com.amazonaws.services.cloudtrail.model.InvalidKmsKeyIdException;
import com.amazonaws.services.cloudtrail.model.InvalidLookupAttributesException;
import com.amazonaws.services.cloudtrail.model.InvalidMaxResultsException;
import com.amazonaws.services.cloudtrail.model.InvalidNextTokenException;
import com.amazonaws.services.cloudtrail.model.InvalidParameterCombinationException;
import com.amazonaws.services.cloudtrail.model.InvalidS3BucketNameException;
import com.amazonaws.services.cloudtrail.model.InvalidS3PrefixException;
import com.amazonaws.services.cloudtrail.model.InvalidSnsTopicNameException;
import com.amazonaws.services.cloudtrail.model.InvalidTagParameterException;
import com.amazonaws.services.cloudtrail.model.InvalidTimeRangeException;
import com.amazonaws.services.cloudtrail.model.InvalidTokenException;
import com.amazonaws.services.cloudtrail.model.InvalidTrailNameException;
import com.amazonaws.services.cloudtrail.model.KmsException;
import com.amazonaws.services.cloudtrail.model.KmsKeyDisabledException;
import com.amazonaws.services.cloudtrail.model.KmsKeyNotFoundException;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysResult;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.services.cloudtrail.model.ListTagsResult;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.LookupEventsResult;
import com.amazonaws.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import com.amazonaws.services.cloudtrail.model.OperationNotPermittedException;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.RemoveTagsResult;
import com.amazonaws.services.cloudtrail.model.ResourceNotFoundException;
import com.amazonaws.services.cloudtrail.model.ResourceTypeNotSupportedException;
import com.amazonaws.services.cloudtrail.model.S3BucketDoesNotExistException;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.TagsLimitExceededException;
import com.amazonaws.services.cloudtrail.model.TrailAlreadyExistsException;
import com.amazonaws.services.cloudtrail.model.TrailNotFoundException;
import com.amazonaws.services.cloudtrail.model.TrailNotProvidedException;
import com.amazonaws.services.cloudtrail.model.UnsupportedOperationException;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudTrailClient
extends AmazonWebServiceClient
implements AWSCloudTrail {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudTrail.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudtrail";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTokenException").withModeledClass(InvalidTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudTrailARNInvalidException").withModeledClass(CloudTrailARNInvalidException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCloudWatchLogsRoleArnException").withModeledClass(InvalidCloudWatchLogsRoleArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidKmsKeyIdException").withModeledClass(InvalidKmsKeyIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withModeledClass(InvalidTimeRangeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withModeledClass(UnsupportedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailNotProvidedException").withModeledClass(TrailNotProvidedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCloudWatchLogsLogGroupArnException").withModeledClass(InvalidCloudWatchLogsLogGroupArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsException").withModeledClass(KmsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("S3BucketDoesNotExistException").withModeledClass(S3BucketDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(InvalidParameterCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMaxResultsException").withModeledClass(InvalidMaxResultsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagsLimitExceededException").withModeledClass(TagsLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3BucketNameException").withModeledClass(InvalidS3BucketNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudWatchLogsDeliveryUnavailableException").withModeledClass(CloudWatchLogsDeliveryUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTrailNameException").withModeledClass(InvalidTrailNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSnsTopicNameException").withModeledClass(InvalidSnsTopicNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientEncryptionPolicyException").withModeledClass(InsufficientEncryptionPolicyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagParameterException").withModeledClass(InvalidTagParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsKeyNotFoundException").withModeledClass(KmsKeyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailNotFoundException").withModeledClass(TrailNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLookupAttributesException").withModeledClass(InvalidLookupAttributesException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaximumNumberOfTrailsExceededException").withModeledClass(MaximumNumberOfTrailsExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3PrefixException").withModeledClass(InvalidS3PrefixException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientSnsTopicPolicyException").withModeledClass(InsufficientSnsTopicPolicyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientS3BucketPolicyException").withModeledClass(InsufficientS3BucketPolicyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidHomeRegionException").withModeledClass(InvalidHomeRegionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceTypeNotSupportedException").withModeledClass(ResourceTypeNotSupportedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailAlreadyExistsException").withModeledClass(TrailAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsKeyDisabledException").withModeledClass(KmsKeyDisabledException.class)).withBaseServiceExceptionClass(AWSCloudTrailException.class));

    public AWSCloudTrailClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSCloudTrailClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSCloudTrailClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cloudtrail.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudtrail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudtrail/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestMarshaller(this.protocolFactory).marshall((AddTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrailResult createTrail(CreateTrailRequest createTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrailRequestMarshaller(this.protocolFactory).marshall((CreateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTrailResult createTrailResult = (CreateTrailResult)response.getAwsResponse();
            return createTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrailResult deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrailRequestMarshaller(this.protocolFactory).marshall((DeleteTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTrailResult deleteTrailResult = (DeleteTrailResult)response.getAwsResponse();
            return deleteTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrailsResult describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrailsRequestMarshaller(this.protocolFactory).marshall((DescribeTrailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTrailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrailsResult describeTrailsResult = (DescribeTrailsResult)response.getAwsResponse();
            return describeTrailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrailsResult describeTrails() {
        return this.describeTrails(new DescribeTrailsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailStatusResult getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTrailStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTrailStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTrailStatusRequestMarshaller(this.protocolFactory).marshall((GetTrailStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTrailStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTrailStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTrailStatusResult getTrailStatusResult = (GetTrailStatusResult)response.getAwsResponse();
            return getTrailStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResult listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPublicKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPublicKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPublicKeysRequestMarshaller(this.protocolFactory).marshall((ListPublicKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPublicKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPublicKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPublicKeysResult listPublicKeysResult = (ListPublicKeysResult)response.getAwsResponse();
            return listPublicKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPublicKeysResult listPublicKeys() {
        return this.listPublicKeys(new ListPublicKeysRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResult listTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestMarshaller(this.protocolFactory).marshall((ListTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupEventsResult lookupEvents(LookupEventsRequest lookupEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lookupEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LookupEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LookupEventsRequestMarshaller(this.protocolFactory).marshall((LookupEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)lookupEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new LookupEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            LookupEventsResult lookupEventsResult = (LookupEventsResult)response.getAwsResponse();
            return lookupEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LookupEventsResult lookupEvents() {
        return this.lookupEvents(new LookupEventsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestMarshaller(this.protocolFactory).marshall((RemoveTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLoggingResult startLogging(StartLoggingRequest startLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLoggingRequestMarshaller(this.protocolFactory).marshall((StartLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)startLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartLoggingResult startLoggingResult = (StartLoggingResult)response.getAwsResponse();
            return startLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopLoggingResult stopLogging(StopLoggingRequest stopLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopLoggingRequestMarshaller(this.protocolFactory).marshall((StopLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopLoggingResult stopLoggingResult = (StopLoggingResult)response.getAwsResponse();
            return stopLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrailResult updateTrail(UpdateTrailRequest updateTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTrailRequestMarshaller(this.protocolFactory).marshall((UpdateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTrailResult updateTrailResult = (UpdateTrailResult)response.getAwsResponse();
            return updateTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

