/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.sample.shadowEcho;

import com.amazonaws.services.iot.client.AWSIotDevice;
import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMqttClient;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.sample.sampleUtil.CommandArguments;
import com.amazonaws.services.iot.client.sample.sampleUtil.SampleUtil;
import com.amazonaws.services.iot.client.sample.shadowEcho.Thing;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ShadowEchoSample {
    private static AWSIotMqttClient awsIotClient;

    public static void setClient(AWSIotMqttClient client) {
        awsIotClient = client;
    }

    private static void initClient(CommandArguments arguments) {
        String clientEndpoint = arguments.getNotNull("clientEndpoint", SampleUtil.getConfig("clientEndpoint"));
        String clientId = arguments.getNotNull("clientId", SampleUtil.getConfig("clientId"));
        String certificateFile = arguments.get("certificateFile", SampleUtil.getConfig("certificateFile"));
        String privateKeyFile = arguments.get("privateKeyFile", SampleUtil.getConfig("privateKeyFile"));
        if (awsIotClient == null && certificateFile != null && privateKeyFile != null) {
            String algorithm = arguments.get("keyAlgorithm", SampleUtil.getConfig("keyAlgorithm"));
            SampleUtil.KeyStorePasswordPair pair = SampleUtil.getKeyStorePasswordPair(certificateFile, privateKeyFile, algorithm);
            awsIotClient = new AWSIotMqttClient(clientEndpoint, clientId, pair.keyStore, pair.keyPassword);
        }
        if (awsIotClient == null) {
            String awsAccessKeyId = arguments.get("awsAccessKeyId", SampleUtil.getConfig("awsAccessKeyId"));
            String awsSecretAccessKey = arguments.get("awsSecretAccessKey", SampleUtil.getConfig("awsSecretAccessKey"));
            String sessionToken = arguments.get("sessionToken", SampleUtil.getConfig("sessionToken"));
            if (awsAccessKeyId != null && awsSecretAccessKey != null) {
                awsIotClient = new AWSIotMqttClient(clientEndpoint, clientId, awsAccessKeyId, awsSecretAccessKey, sessionToken);
            }
        }
        if (awsIotClient == null) {
            throw new IllegalArgumentException("Failed to construct client due to missing certificate or credentials.");
        }
    }

    public static void main(String[] args) throws IOException, AWSIotException, AWSIotTimeoutException, InterruptedException {
        CommandArguments arguments = CommandArguments.parse(args);
        ShadowEchoSample.initClient(arguments);
        String thingName = arguments.getNotNull("thingName", SampleUtil.getConfig("thingName"));
        AWSIotDevice device = new AWSIotDevice(thingName);
        awsIotClient.attach(device);
        awsIotClient.connect();
        device.delete();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Thing thing = new Thing();
        while (true) {
            long desired;
            thing.state.reported.counter = desired = thing.state.desired.counter;
            thing.state.desired.counter = desired + 1L;
            String jsonState = objectMapper.writeValueAsString((Object)thing);
            try {
                device.update(jsonState);
                System.out.println(System.currentTimeMillis() + ": >>> " + jsonState);
            }
            catch (AWSIotException e) {
                System.out.println(System.currentTimeMillis() + ": update failed for " + jsonState);
                continue;
            }
            try {
                String shadowState = device.get();
                System.out.println(System.currentTimeMillis() + ": <<< " + shadowState);
                thing = (Thing)objectMapper.readValue(shadowState, Thing.class);
            }
            catch (AWSIotException e) {
                System.out.println(System.currentTimeMillis() + ": get failed for " + jsonState);
                continue;
            }
            Thread.sleep(1000L);
        }
    }
}

